<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php $__env->startSection('title', 'Totales Mensuales'); ?>

    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card border-0">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col">
                                <h4 class="card-title mb-0">Totales Mensuales de Cobranzas</h4>
                                <p class="text-muted mb-0">Análisis mensual con variación porcentual</p>
                            </div>
                            <div class="col-auto">
                                <form method="GET" action="<?php echo e(route('totales.mensuales')); ?>" class="d-flex align-items-center" id="yearForm">
                                    <label for="year" class="form-label me-2 mb-0">Año:</label>
                                    <select name="year" id="year" class="form-select me-2" style="width: auto;" onchange="showLoading()">
                                        <?php $__currentLoopData = $añosDisponibles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $año): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($año); ?>" <?php echo e($año == $year ? 'selected' : ''); ?>>
                                                <?php echo e($año); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Loading indicator -->
                        <div id="loadingIndicator" class="text-center py-5" style="display: none;">
                            <div class="spinner-border text-primary" role="status">
                                <span class="visually-hidden">Cargando...</span>
                            </div>
                            <p class="text-muted mt-3">Cargando datos del año seleccionado...</p>
                        </div>

                        <!-- Table content -->
                        <div id="tableContent">
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead class="table-dark">
                                        <tr>
                                            <th class="text-start">Mes</th>
                                            <th class="text-end">Total</th>
                                            <th class="text-end">Utilidad Bruta</th>
                                            <th class="text-end">Utilidad Neta</th>
                                            <th class="text-end">Total Comisiones</th>
                                            <th class="text-end">Variación vs. Mes Anterior (%)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $totalesMensuales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="text-start fw-semibold"><?php echo e($mes['mes']); ?></td>
                                                <td class="text-end">
                                                    <span class="fw-bold">$<?php echo e(number_format($mes['total'], 0, ',', '.')); ?></span>
                                                </td>
                                                <td class="text-end">
                                                    <span class="fw-bold <?php echo e($mes['utilidad_bruta'] >= 0 ? 'text-success' : 'text-danger'); ?>">
                                                        $<?php echo e(number_format($mes['utilidad_bruta'], 0, ',', '.')); ?>

                                                    </span>
                                                </td>
                                                <td class="text-end">
                                                    <span class="fw-bold <?php echo e($mes['utilidad_neta'] >= 0 ? 'text-success' : 'text-danger'); ?>">
                                                        $<?php echo e(number_format($mes['utilidad_neta'], 0, ',', '.')); ?>

                                                    </span>
                                                </td>
                                                <td class="text-end">
                                                    <span class="fw-bold text-info">
                                                        $<?php echo e(number_format($mes['comisiones'], 0, ',', '.')); ?>

                                                    </span>
                                                </td>
                                                <td class="text-end">
                                                    <?php if($mes['variacion'] !== null): ?>
                                                        <span class="badge <?php echo e($mes['variacion'] >= 0 ? 'bg-success' : 'bg-danger'); ?>">
                                                            <?php echo e($mes['variacion_formateada']); ?>

                                                        </span>
                                                    <?php else: ?>
                                                        <span class="text-muted">–</span>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>

                            <?php if(empty(array_filter($totalesMensuales, fn($mes) => $mes['total'] > 0))): ?>
                                <div class="text-center py-5">
                                    <div class="text-muted">
                                        <i class="fas fa-chart-line fa-3x mb-3"></i>
                                        <h5>No hay datos disponibles</h5>
                                        <p class="text-muted">No se encontraron cobranzas para el año <?php echo e($year); ?></p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .table th {
            border-top: none;
            font-weight: 600;
        }

        .table tbody tr:hover {
            background-color: rgba(0, 0, 0, 0.05);
        }

        .badge {
            font-size: 0.75em;
            padding: 0.375rem 0.5rem;
        }

        .card-header {
            background-color: #f8f9fa;
            border-bottom: 1px solid #dee2e6;
        }

        .spinner-border {
            width: 3rem;
            height: 3rem;
        }

        #tableContent {
            transition: opacity 0.3s ease-in-out;
        }

        /* Dark mode styles */
        [data-theme="dark"] .card-header {
            background-color: #343a40;
            border-bottom: 1px solid #6c757d;
        }

        [data-theme="dark"] .card {
            background-color: #343a40;
            border-color: #6c757d;
        }

        [data-theme="dark"] .card-title {
            color: #ffffff !important;
        }

        [data-theme="dark"] .table tbody tr {
            background-color: #495057;
        }

        [data-theme="dark"] .table tbody tr:hover {
            background-color: rgba(255, 255, 255, 0.1) !important;
        }

        [data-theme="dark"] .table tbody td {
            border-color: #6c757d;
            color: #ffffff;
        }

        [data-theme="dark"] .table th {
            background-color: #343a40 !important;
            color: #ffffff !important;
            border-color: #6c757d;
        }

        [data-theme="dark"] .form-select {
            background-color: #495057;
            border-color: #6c757d;
            color: #ffffff;
        }

        [data-theme="dark"] .form-select:focus {
            background-color: #495057;
            border-color: #0d6efd;
            color: #ffffff;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }

        [data-theme="dark"] .form-label {
            color: #ffffff !important;
        }

        [data-theme="dark"] .text-muted {
            color: #6c757d !important;
        }

        [data-theme="dark"] .spinner-border.text-primary {
            color: #0d6efd !important;
        }
    </style>

    <script>
        function showLoading() {
            // Mostrar indicador de carga
            document.getElementById('loadingIndicator').style.display = 'block';
            document.getElementById('tableContent').style.display = 'none';
        }

        function hideLoading() {
            // Ocultar indicador de carga y mostrar tabla
            document.getElementById('loadingIndicator').style.display = 'none';
            document.getElementById('tableContent').style.display = 'block';
        }

        function loadYearData(year) {
            showLoading();

            // Realizar petición AJAX
            fetch(`<?php echo e(route('totales.mensuales')); ?>?year=${year}`, {
                method: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'text/html',
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.text();
            })
            .then(html => {
                // Crear un elemento temporal para parsear el HTML
                const tempDiv = document.createElement('div');
                tempDiv.innerHTML = html;

                // Extraer solo el contenido de la tabla
                const newTableContent = tempDiv.querySelector('#tableContent');

                if (newTableContent) {
                    // Actualizar el contenido de la tabla con una transición suave
                    const currentTableContent = document.getElementById('tableContent');
                    currentTableContent.style.opacity = '0';

                    setTimeout(() => {
                        currentTableContent.innerHTML = newTableContent.innerHTML;
                        currentTableContent.style.opacity = '1';
                        hideLoading();
                    }, 150);
                } else {
                    hideLoading();
                }
            })
            .catch(error => {
                console.error('Error:', error);
                hideLoading();
                // Mostrar mensaje de error
                alert('Error al cargar los datos. Recargando la página...');
                // En caso de error, recargar la página
                window.location.href = `<?php echo e(route('totales.mensuales')); ?>?year=${year}`;
            });
        }

        // Event listener para el cambio de año
        document.addEventListener('DOMContentLoaded', function() {
            const yearSelect = document.getElementById('year');
            if (yearSelect) {
                yearSelect.addEventListener('change', function() {
                    const selectedYear = this.value;
                    if (selectedYear) {
                        loadYearData(selectedYear);
                    }
                });
            }
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/totales-mensuales.blade.php ENDPATH**/ ?>