<?php
$personas_route = 'personas.index';
$socios_route = 'socios.index';
$tecnicos_route = 'tecnicos.index';
$vendedores_route = 'vendedores.index';

$entidades = ['personas', 'socios', 'tecnicos', 'vendedores'];
$menu_personas_routes = [$personas_route, $socios_route, $tecnicos_route, $vendedores_route];
?>

<li class="nav-item dropdown">
    <a class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>
        Str::contains(Route::currentRouteName(), $entidades) && !is_current_route(['reporte_vendedores.index'])]); ?>"
        href="#personaCollapse" data-bs-toggle="collapse"
        role="button"
        aria-controls="personaCollapse">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="nav-link-icon" height="18" width="18">
            <circle class="a" cx="12" cy="6" r="5.25" />
            <path class="a" d="M7.476,3.335A8.714,8.714,0,0,0,13.75,6,8.725,8.725,0,0,0,17.2,5.29" fill="none"
                stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
            <line class="a" x1="6.25" y1="23.25" x2="6.25" y2="15.448" />
            <line class="a" x1="17.75" y1="23.25" x2="17.75" y2="15.379" />
            <path class="a" d="M14.75,16.175V19.75a1,1,0,0,1-1,1h-3.5a1,1,0,0,1-1-1V16.175" fill="none"
                stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
            <path class="a" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                stroke-width="1.5"
                d="M2.25,23.25a9.76,9.76,0,0,1,5.43-8.74h0a4.992,4.992,0,0,0,8.64,0h0a9.76,9.76,0,0,1,5.43,8.74" />
        </svg>
        <span>Menú Personas</span>
    </a>
    <div class="<?php echo e(Str::contains(Route::currentRouteName(), $entidades) && !is_current_route(['reporte_vendedores.index']) ? 'collapse show' : 'collapse'); ?>"
        id="personaCollapse">
        <ul class="nav flex-column">
            
            <li class="nav-item">
                <a href="<?php echo e(route($socios_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>
                    Str::contains(Route::currentRouteName(), 'socios')]); ?>">
                    <span>Socios</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="<?php echo e(route($tecnicos_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>
                    Str::contains(Route::currentRouteName(), 'tecnicos')]); ?>">
                    <span>Técnicos</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="<?php echo e(route($vendedores_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>
                    is_current_route([$vendedores_route])]); ?>">
                    <span>Vendedores</span>
                </a>
            </li>
        </ul>
    </div>
</li><?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/layouts/sidebar/items/personas.blade.php ENDPATH**/ ?>