<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Factura #<?php echo e($numero_factura_simple); ?></title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 14px;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .header {
            width: 100%;
            margin-bottom: 30px;
        }
        .header table {
            width: 100%;
        }
        .company-info {
            width: 50%;
            vertical-align: top;
        }
        .invoice-title {
            width: 50%;
            text-align: right;
            vertical-align: top;
        }
        .invoice-title h1 {
            color: #009999; /* Example teal color */
            margin: 0;
            font-size: 24px;
        }
        .logo {
            text-align: right;
            margin-top: 10px;
        }
        .logo img{
            max-width: 200px;
        }

        .billing-info {
            margin-top: 30px;
            width: 100%;
            border-top: 2px solid #009999;
            padding-top: 10px;
        }
        .billing-table {
            width: 100%;
            border-collapse: collapse;
        }
        .billing-table td {
            vertical-align: top;
        }
        .bill-to {
            width: 50%;
        }
        .invoice-details-box {
            width: 50%;
            /* background-color: #e0f2f1;  Light teal background */
        }
        .invoice-details-table {
            width: 100%;
            border-collapse: collapse;
        }
        .invoice-details-table th, .invoice-details-table td {
            padding: 10px;
            text-align: center;
        }
        .invoice-details-table th {
            color: #00897b;
            font-weight: normal;
            font-size: 12px;
        }
        .invoice-details-table td {
            font-weight: bold;
            font-size: 14px;
            color: #00695c;
        }
        .bg-teal-light {
             background-color: #d1e7dd; /* Light green/teal */
        }
        .bg-teal-dark {
            background-color: #00897b; /* Dark teal */
            color: white !important;
        }
        .bg-teal-dark td {
             color: white !important;
        }


        .items-table {
            width: 100%;
            margin-top: 30px;
             border-collapse: collapse;
        }
        .items-table th {
            text-align: left;
            padding: 10px 5px;
            font-size: 10px;
            text-transform: uppercase;
            border-bottom: 1px solid #ddd;
            color: #333;
        }
        .items-table td {
             padding: 10px 5px;
             border-bottom: 1px solid #eee;
        }
        .text-right {
            text-align: right !important;
        }
        .text-center {
            text-align: center !important;
        }

        .footer-section {
            margin-top: 30px;
            width: 100%;
        }
        .footer-table {
             width: 100%;
        }
        .bank-details {
            width: 60%;
            font-size: 12px;
            line-height: 1.5;
        }
        .totals-section {
            width: 40%;
            vertical-align: top;
        }
        .totals-table {
            width: 100%;
            border-collapse: collapse;
        }
        .totals-table td {
            padding: 10px;
        }
        .total-due-label {
             color: #009999;
             font-weight: bold;
             border-top: 1px solid #009999;
             border-bottom: 1px solid #009999;
        }
        .total-due-amount {
             color: #009999;
             font-weight: bold;
             font-size: 20px;
             text-align: right;
              border-top: 1px solid #009999;
             border-bottom: 1px solid #009999;
        }
        .thank-you {
            text-align: right;
            padding-top: 10px;
            color: #009999;
            font-size: 12px;
        }
    </style>
</head>
<body>

    <div class="header">
        <table>
            <tr>
                <td class="company-info">
                    <strong>CloudSAT LLC</strong><br>
                    3625 Northwest 82nd Avenue<br>
                    Doral, FL 33166 VE<br>
                    +14049023049<br>
                    cloudsatllc@gmail.com
                </td>
                <td class="invoice-title">
                    <h1>Factura #<?php echo e($numero_factura_simple); ?></h1>
                    <div class="logo">
                         <?php if($logo_base64): ?>
                            <img src="<?php echo e($logo_base64); ?>" alt="Logo" style="max-height: 80px;">
                         <?php else: ?>
                            <h2 style="color: #0056b3;">CloudSat</h2>
                         <?php endif; ?>
                    </div>
                </td>
            </tr>
        </table>
    </div>

    <div class="billing-info">
        <table class="billing-table">
            <tr>
                <td class="bill-to">
                    <strong>FACTURAR A</strong><br>
                    <?php echo $factura->equipo != 'N/A' ? $factura->equipo . '<br>' : ''; ?>

                    <?php echo e($factura->cliente_nombre); ?><br>
                    
                </td>
                <td class="invoice-details-box">
                    <table class="invoice-details-table">
                        <tr>
                            <th class="bg-teal-light">FECHA</th>
                            <th class="bg-teal-dark" style="color: white;">TOTAL A PAGAR</th>
                            <th class="bg-teal-light">VENCIMIENTO</th>
                        </tr>
                        <tr>
                            <td class="bg-teal-light"><?php echo e($fecha_emision->format('d/m/Y')); ?></td>
                            <td class="bg-teal-dark" style="color: white; font-size: 16px;">$<?php echo e(number_format($factura->monto_total, 2)); ?></td>
                            <td class="bg-teal-light"><?php echo e($fecha_vencimiento->format('d/m/Y')); ?></td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>

    <table class="items-table">
        <thead>
            <tr>
                <th>FECHA</th>
                <th>ACTIVIDAD</th>
                <th>DESCRIPCIÓN</th>
                <th class="text-center">CANT</th>
                <th class="text-right">PRECIO</th>
                <th class="text-right">IMPORTE</th>
            </tr>
        </thead>
        <tbody>
            
            <tr>
                <td><?php echo e($fecha_cobro->format('d/m/Y')); ?></td>
                <td><strong><?php echo e($factura->plan_nombre); ?></strong></td>
                <td><?php echo e($factura->concepto); ?></td>
                <td class="text-center">1</td>
                <td class="text-right"><?php echo e(number_format($factura->monto_total, 2)); ?></td>
                <td class="text-right"><?php echo e(number_format($factura->monto_total, 2)); ?></td>
            </tr>
        </tbody>
    </table>

    <div class="footer-section">
        <table class="footer-table">
            <tr>
                <td class="bank-details">
                    <strong>BOFA</strong><br>
                    
                    Correo: cloudsatllc@gmail.com<br>
                    Nombre Completo del Titular: Cloudsat LLC<br>
                    Número de ruta ACH: 111000025<br>
                    Número de cuenta: 488118153351<br>
                    Trans cable: 026009593<br>
                    Tipo de Cuenta: Business ADV fundamentls<br>
                    Zelle cloudsatllc@gmail.com<br>
                    Cloudsat LLC
                </td>
                <td class="totals-section">
                    <table class="totals-table">
                        <tr>
                            <td class="total-due-label">TOTAL A PAGAR</td>
                            <td class="total-due-amount">$<?php echo e(number_format($factura->monto_total, 2)); ?></td>
                        </tr>
                    </table>
                    <div class="thank-you">GRACIAS.</div>
                </td>
            </tr>
        </table>
    </div>

</body>
</html>
<?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/pdf/factura_mensualidad.blade.php ENDPATH**/ ?>