<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte gerencial</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css"
        integrity="sha384-zCbKRCUGaJDkqS1kPbPX4m9Gv8iQgA70ZvCKmWl5+h8ACV4Q5Nlt+MCYL9WhW5" crossorigin="anonymous">

    <link rel="preload" as="style"
        href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&display=swap">
    <link rel="stylesheet" media="print" onload="this.onload=null;this.removeAttribute('media');"
        href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&display=swap">
    <style>
        /* body {
            background-image: url('<?php echo e(public_path().$logo); ?>');
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center;
            background-size: 350px 150px;

        } */

        .large-font {
            font-size: 1.5rem;
            /* Ajusta el tamaño según sea necesario */
        }

        .medium-font {
            font-size: 0.8rem;
            /* Ajusta el tamaño según sea necesario */
        }

        .small-font {
            font-size: 0.6rem;
            /* Ajusta el tamaño según sea necesario */
        }

        .text-vertical-center {
            display: flex;
            align-items: center;
            /* Centra verticalmente */
            height: 100px;
            /* Ajusta la altura según sea necesario */
        }

        body {
            margin: 0px;
            padding: 0px;
            /* Ajusta el valor según sea necesario */
        }

        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-image: url('<?php echo e(public_path().$logo); ?>');
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center;
            background-size: 400px 120px;
            opacity: 0.1;
            /* Ajusta la opacidad aquí */
            z-index: -1;
            /* Coloca el pseudo-elemento detrás del contenido */
        }
    </style>
</head>

<body>
    <div class="">
        <div class="row medium-font">
            <div class="col col-md-6">
                
                <img src="<?php echo e(public_path().$logo); ?>" class="mb-3" width="200" height="65">

            </div>
            <div class="col col-md-2  opacity-full">
                <p class="large-font mb-3 font-weight-bold text-center">Reporte Gerencial</p>
                
                <p>
                    
                    <br><strong>Periodo:</strong><?php echo e($fechas['fecha_desde'].' - '.$fechas['fecha_hasta']); ?>

                    
                </p>
            </div>
        </div>


        
        <div class="row col-md-12">
            <table class="table table-striped table-bordered small-font">
                <thead>
                    
                    <tr class="align-middle">
                        <th class="align-middle text-center">Total de remotas</th>
                        <th class="align-middle text-center">Activas</th>
                        <th class="align-middle text-center">Inactivas</th>
                        <th class="align-middle text-center">Pausadas</th>
                        <th class="align-middle text-center">Pausadas por pago</th>
                    </tr>
                </thead>
                <tbody>

                    <tr>
                        <td class="text-right"><?php echo e($datos['remotasTotal']); ?></td>
                        <td class="text-right"><?php echo e($datos['remotasActivas']); ?></td>
                        <td class="text-right"><?php echo e($datos['remotasInactivas']); ?></td>
                        <td class="text-right"><?php echo e($datos['remotasPausadas']); ?></td>
                        <td class="text-right"><?php echo e($datos['remotasPausadasPorPago']); ?></td>
                    </tr>




                </tbody>

            </table>
        </div>
        <hr>
        
        <div class="row col-md-12">
            <table class="table table-striped table-bordered small-font">
                <thead>

                    <tr class="align-middle">
                        <th class="align-middle text-center">Total cobranzas</th>
                        <th class="align-middle text-center">Total de clientes</th>
                        <th class="align-middle text-center">Total de mensualidades</th>
                        <th class="align-middle text-center">Total de pagos Foraneos</th>
                        <th class="align-middle text-center">Total de pagos</th>
                    </tr>
                </thead>
                <tbody>


                    <tr>
                        <td class="text-right"><?php echo e($datos['totalCobranzas'] ?? 0); ?></td>
                        <td class="text-right"><?php echo e($datos['clientes']); ?></td>
                        <td class="text-right">$<?php echo number_format($datos['totalDeMensualidades'], 2, '.', ','); ?></td>
                        <td class="text-right">$<?php echo number_format($datos['totalDePagosForaneos'], 2, '.', ','); ?></td>
                        <td class="text-right">$<?php echo number_format($datos['totalCobros'], 2, '.', ','); ?></td>
                    </tr>



                </tbody>

            </table>
        </div>
        
        <div class="row col-md-12">
            <table class="table table-striped table-bordered small-font">
                <thead>
                    <tr>
                        <th colspan="4">Mensualidades</th>
                    </tr>
                    <tr class="align-middle">
                        <th class="align-middle text-center">Total de pagado</th>
                        <th class="align-middle text-center">Total de costo</th>
                        <th class="align-middle text-center">Total de comisiones</th>
                        <th class="align-middle text-center">Total de utilidad</th>
                    </tr>
                </thead>
                <tbody>

                    
                    <tr>
                        <td class="text-right">$<?php echo number_format($datos['totalPagadoMensualidades'], 2, '.', ','); ?></td>
                        <td class="text-right">$<?php echo number_format($datos['TotalCostoMensualidades'], 2, '.', ','); ?></td>
                        <td class="text-right">$<?php echo number_format($datos['totalComisionesMensualidades'], 2, '.', ','); ?></td>
                        <td class="text-right">$<?php echo number_format($datos['totalUtilidadMensualidades'], 2, '.', ','); ?></td>
                    </tr>



                </tbody>

            </table>
        </div>
        
        





        
        <div class="row col-md-12">
            <table class="table table-striped table-bordered small-font">
                <thead>
                    <tr>
                        <th colspan="3">Métodos de pago recibidos</th>
                    </tr>
                    <tr class="align-middle">
                        <th class="align-middle text-center">Método de pago</th>
                        <th class="align-middle text-center">Cantidad de transacciones</th>
                        <th class="align-middle text-center">Monto total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($datos['metodosPago']) && count($datos['metodosPago']) > 0): ?>
                        <?php $__currentLoopData = $datos['metodosPago']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $metodo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="text-left"><?php echo e($metodo['nombre'] ?? 'N/A'); ?></td>
                                <td class="text-right"><?php echo e($metodo['cantidad'] ?? 0); ?></td>
                                <td class="text-right">$<?php echo e(number_format($metodo['monto'] ?? 0, 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3" class="text-center">No hay datos de métodos de pago disponibles</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <hr>
        
        <div class="row col-md-12">
            <table class="table table-striped table-bordered small-font">
                <thead>
                    <tr>
                        <th colspan="4">Total de pagos a proveedores</th>
                    </tr>
                    <tr>
                        <th colspan="2">CloudSat</th>
                        <th colspan="2">Rebaur</th>
                    </tr>

                </thead>
                <tbody>


                    <tr>
                        <td class="text-right" colspan="2">$<?php echo number_format($datos['CloudSatPagos'], 2, '.', ','); ?></td>
                        <td class="text-right" colspan="2">$<?php echo number_format($datos['RebaurPagos'], 2, '.', ','); ?></td>
                    </tr>


                </tbody>

            </table>
        </div>


    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js"
        integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-fQybjgWLrvvR+DLTsDeeXhc01hgwTGp/n5+y0tGvFCRQjZhjgrhntLZnjxDzfbT" crossorigin="anonymous">
    </script>
</body>

</html>
<?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/reportes/pdf/reporte_gerencial.blade.php ENDPATH**/ ?>