<div>
    <?php $__env->startSection('title', 'Historial de cobros realizados'); ?>


    <style>
        td {
            /* min-height: 60px;
            max-height: 70px; */
            /* max-width: 80px; */
            font-size: 14px;
        }

        .table * {
            border-bottom-width: 2px;
        }



        .table th,
        .table td {
            padding: 10px 15px 10px 5px;
        }

        .table thead th {
            padding: 0px 0px 10px 0px;
        }
    </style>
    <div class=" pt-2 d-flex flex-column">

        <header class="mb-4">
            <h1 class="text-center h1">Historial de cobros</h1>
        </header>




        
        <div class="row mt-3">
            <div class="card shadow p-0">
                

                    <div class="card-header pb-2">
                        <div class="row">
                            <p class="col">
                                Cobros de mensualidades pendientes
                            </p>

                            <div class="col  d-flex flex-column align-items-end">
                                <input class="form-control list-search mw-300px d-none  " wire:model.live="search"
                                    type="search" placeholder="Buscar">

                            </div>

                        </div>
                    </div>

                    <div class="card-body ">

                        <table class="table table-striped mt-40 datatable">
                            
                            <thead>
                                <tr>
                                    <th scope="col" class="text-center  ">#</th>
                                    <th scope="col" class="text-center  ">Cliente</th>
                                    <th scope="col" class="text-center  ">Remota</th>
                                    <th scope="col" class="text-center  ">Concepto</th>
                                    <th scope="col" class="text-center  ">Metodo de pago</th>
                                    <th scope="col" class="text-center  ">Monto</th>
                                    <th scope="col" class="text-center  ">Fecha</th>
                                    <th scope="col" class="text-center">Acción</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $cobros_historial; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cobro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    
                                    <td class="text-center"><?php echo e($cobro->id); ?></td>
                                    
                                    <td scope="col" class="text-left ">
                                        <?php echo e(($cobro->remota?->cliente->getClientName()??
                                        $cobro->cliente->getClientName()?? 'Error de
                                        cliente')); ?>

                                    </td>
                                    
                                    <td scope="col" class="text-left ">
                                        <?php echo e(($cobro->remota?->equipo ?? '')?? 'ERROR: Remota'); ?>

                                    </td>
                                    
                                    <td scope="col" class="text-left ">
                                        <?php echo e($cobro->concepto); ?>

                                    </td>
                                    
                                    <td scope="col" class="text-left ">
                                        <?php echo e($cobro->payment_method?->getName() ?? 'N/R'); ?>

                                    </td>
                                    
                                    <td scope="col" class="text-left ">
                                        $<?php echo number_format($cobro->monto, 2, '.', ','); ?>
                                    </td>
                                    
                                    <td scope="col" class="text-left">
                                        <?php echo e($cobro->fecha_pago); ?>

                                    </td>
                                    
                                    <td scope="col" class="">
                                        <div class="text-center d-flex flex-row align-items-center justify-content-center gap-2">
                                            <!-- Botón ver recibo -->
                                            <a href="<?php echo e(route('recibos.ver', $cobro->id)); ?>" 
                                               target="_blank"
                                               class="btn btn-sm btn-info" 
                                               title="Ver recibo">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <!-- Botón descargar recibo -->
                                            <a href="<?php echo e(route('recibos.descargar', $cobro->id)); ?>" 
                                               class="btn btn-sm btn-success" 
                                               title="Descargar recibo">
                                                <i class="fas fa-download"></i>
                                            </a>
                                        </div>
                                    </td>


                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td colspan="8" class="text-center">No hay cobros por mensualidades proximos a 5
                                    dias a vencer</td>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            </tbody>
                        </table>



                    </div>

                </div>

            </div>





        </div>

    </div>
</div>
<?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/livewire/cobranza/cobros-historial-component.blade.php ENDPATH**/ ?>