<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Tabla'); ?></title>
    
    <style>
        td {
            font-size: 14px;
        }

        .table * {
            border-bottom-width: 2px;
        }

        .table th,
        .table td {
            padding: 2px 5px;
        }

        .table thead th {
            padding: 0px 0px 10px 0px;
        }

        .col-75 {
            width: 75%;
        }

        .col-60 {
            width: 60%;
        }

        .col-50 {
            width: 50%;
        }

        .col-40 {
            width: 40%;
        }

        .col-25 {
            width: 25%;
        }

        .col-15 {
            width: 15%;
        }

        .col-10 {
            width: 10%;
        }

        .col-5 {
            width: 5%;
        }
    </style>
    <?php echo $__env->yieldContent('head'); ?>
</head>

<body>
    <div class="pt-2 d-flex flex-column">
        <header class="mb-4">
            <h1 class="text-center h1"><?php echo $__env->yieldContent('header', 'Título de la Tabla'); ?></h1>
        </header>
        <div class="row mt-3">
            <div class="card shadow p-0">
                <div class="card-header pb-2">
                    <div class="row">
                        <p class="col"><?php echo $__env->yieldContent('header-text', 'Subtítulo'); ?></p>
                        <div class="col d-flex flex-column align-items-end">
                            <?php echo $__env->yieldContent('header-actions'); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <table class="table table-striped table-hover table-bordered datatable mt-40">
                        <thead>
                            <?php echo $__env->yieldContent('table-head'); ?>
                        </thead>
                        <tbody>
                            <?php echo $__env->yieldContent('table-body'); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html>
<?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/layouts/table-page.blade.php ENDPATH**/ ?>