<?php
$modelos_route = 'mikrotiks.modelos.index';
$protocolos_route = 'mikrotiks.protocolos.index';
$mikrotik_route = 'mikrotiks.index';

$entidades = ['modelos', 'protocolos', 'mikrotik'];

$menu_mikrotiks_routes = [$modelos_route, $protocolos_route, $mikrotik_route];
?>
<li class="nav-item dropdown">
    <a class="<?php echo \Illuminate\Support\Arr::toCssClasses([ 'nav-link' , 'active'=> Str::contains(Route::currentRouteName(), $entidades)]); ?>" href="#mikrotikCollapse"
        data-bs-toggle="collapse" role="button"
        aria-controls="mikrotikCollapse">
        <svg xmlns="http://www.w3.org/2000/svg" fill="none" class="nav-link-icon" height="18" width="18"
            viewBox="0 0 24 24">
            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                d="M4.125 21.751V23.251" />
            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                d="M19.875 21.751V23.251" />
            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                d="M9.75 15.001V21.751" />
            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                d="M17.25 15.001V6.75098" />
            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                d="M15.129 4.62897C15.6916 4.06656 16.4545 3.75061 17.25 3.75061C18.0455 3.75061 18.8084 4.06656 19.371 4.62897" />
            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                d="M13.007 2.50802C13.5642 1.95076 14.2256 1.50872 14.9537 1.20713C15.6817 0.905533 16.462 0.750305 17.25 0.750305C18.038 0.750305 18.8183 0.905533 19.5463 1.20713C20.2744 1.50872 20.9358 1.95076 21.493 2.50802" />
            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                d="M19.875 21.751C20.7701 21.751 21.6286 21.3954 22.2615 20.7625C22.8944 20.1295 23.25 19.2711 23.25 18.376C23.25 17.4809 22.8944 16.6224 22.2615 15.9895C21.6286 15.3566 20.7701 15.001 19.875 15.001H4.125C3.22989 15.001 2.37145 15.3566 1.73851 15.9895C1.10558 16.6224 0.75 17.4809 0.75 18.376C0.75 19.2711 1.10558 20.1295 1.73851 20.7625C2.37145 21.3954 3.22989 21.751 4.125 21.751H19.875Z" />
            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                d="M18.75 18.75C18.5429 18.75 18.375 18.5821 18.375 18.375C18.375 18.1679 18.5429 18 18.75 18" />
            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                d="M18.75 18.75C18.9571 18.75 19.125 18.5821 19.125 18.375C19.125 18.1679 18.9571 18 18.75 18" />
            <g>
                <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                    stroke-width="1.5"
                    d="M14.25 18.75C14.0429 18.75 13.875 18.5821 13.875 18.375C13.875 18.1679 14.0429 18 14.25 18" />
                <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                    stroke-width="1.5"
                    d="M14.25 18.75C14.4571 18.75 14.625 18.5821 14.625 18.375C14.625 18.1679 14.4571 18 14.25 18" />
            </g>
        </svg>
        <span>Mikrotik Satelital</span>
    </a>
    <div class="<?php echo e(Str::contains(Route::currentRouteName(), $entidades) ? 'collapse show' : 'collapse'); ?>"
        id="mikrotikCollapse">
        <ul class="nav flex-column">
            <li class="nav-item">
                <a href="<?php echo e(route($modelos_route)); ?>"
                    class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>Str::contains(Route::currentRouteName(), 'mikrotiks.modelos')]); ?>">
                    <span>Modelos </span>
                </a>

            </li>
            <li class="nav-item">
                <a href="<?php echo e(route($protocolos_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses([ 'nav-link' , 'active'=>
                    is_current_route([$protocolos_route]),
                    ]); ?>">
                    <span>Protocolos</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="<?php echo e(route($mikrotik_route)); ?>"
                    class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>Str::contains(Route::currentRouteName(),
                    ['mikrotiks.index','mikrotiks.create'])]); ?>">
                    <span>Mikrotik </span>
                </a>
            </li>
        </ul>
    </div>
</li><?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/layouts/sidebar/items/mikrotiks.blade.php ENDPATH**/ ?>