<?php

use App\Http\Controllers\Auth\CustomLoginController;
use App\Http\Controllers\ClienteController;
use App\Http\Controllers\CobranzaController;
use App\Http\Controllers\ConfiguracionController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PersonasController;
use App\Http\Controllers\ReciboCobranzaController;
use App\Http\Controllers\RemotasController;
use App\Http\Controllers\ReportesController;
use App\Http\Controllers\SociosController;
use App\Http\Controllers\TotalesMensualesController;
use App\Livewire\Admin\PaymentMethodComponent;
use App\Livewire\Cliente\ClienteComponent;
use App\Livewire\ClientesTable;
use App\Livewire\Cobranza\PrevisionesDePagoComponent;
use App\Livewire\Cobranza\CobranzaComponent;
use App\Livewire\Cobranza\CobranzaFormComponent;
use App\Livewire\Cobranza\CobrosComponent;
use App\Livewire\Cobranza\CobrosHistorialComponent;
use App\Livewire\Cobranza\CobrosMensualidadesComponent;
use App\Livewire\Cobranza\CobrosMensualidadesFuturasComponent;
use App\Livewire\Empresa\EmpresaComponent;
use App\Livewire\Empresa\EmpresaFormComponent;
use App\Livewire\Home\CuentasPorCobrarMensualActualComponent;
use App\Livewire\Home\HomeComponent;
use App\Livewire\Home\IngresoMensualActualComponent;
use App\Livewire\Mikrotik\MikrotikComponent;
use App\Livewire\Mikrotik\MikrotikFormComponent;
use App\Livewire\Mikrotik\ModeloMikrotikComponent;
use App\Livewire\Mikrotik\ProtocoloMikrotikComponent;
use App\Livewire\PermisosComponent;
use App\Livewire\Persona\PersonaComponent;
use App\Livewire\Persona\PersonaFormComponent;
use App\Livewire\Plan\PlanComponent;
use App\Livewire\Plan\PlanFormComponent;
use App\Livewire\Proveedor\ProveedorComponent;
use App\Livewire\Proveedor\ProveedorFormComponent;
use App\Livewire\Remota\RemotaComponent;
use App\Livewire\Remota\RemotaFormComponent;
use App\Livewire\ReporteVendedoresComponent;
use App\Livewire\RolesComponent;
use App\Livewire\Socio\SocioComponent;
use App\Livewire\Socio\SocioFormComponent;
use App\Livewire\Tecnico\TecnicoComponent;
use App\Livewire\Tecnico\TecnicoFormComponent;
use App\Livewire\User\UserComponent;
use App\Livewire\User\UserProfileComponent;
use App\Livewire\Vendedor\VendedorComponent;
use App\Livewire\Vendedor\VendedorFormComponent;
use App\Models\Cobranza;
use App\Models\Remota;
use Carbon\Carbon;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//========================= Rutas guest
// Route::get('/', function () {
//     if (session()->has('message')) $this->alert(session('type'), session('message'));
//     return view('auth.login');
// });

Route::get('/login', function () {
    return abort(404);
    // return '';
});

Route::get('/drok', function () {
    return view('auth.login');
})->name('drok');

Route::post('/drok', [CustomLoginController::class, 'store'])
    ->middleware(['guest', 'throttle:login'])
    ->name('drok.store');

Route::post('/logout', [CustomLoginController::class, 'logout'])
    ->middleware(['auth'])
    ->name('logout');


Route::get('/reload-captcha', [CustomLoginController::class, 'reloadCaptcha'])
    ->middleware(['guest'])
    ->name('reload-captcha');
//======================== Rutas autenticado
Route::middleware(
    [
        'auth'
    ]
)->group(function () {

    Route::get('/dashboard', [HomeController::class, 'index'])->name('dashboard');
    Route::get('/dashboard/ingreso_mensual_actual', IngresoMensualActualComponent::class)->name('dashboard.ingreso_mensual_actual');
    Route::get('/dashboard/cuentas_por_cobrar_mensual_actual', CuentasPorCobrarMensualActualComponent::class)->name('dashboard.cuentas_por_cobrar_mensual_actual');
    Route::get('/totales-mensuales', [TotalesMensualesController::class, 'index'])->name('totales.mensuales');

    // Route::get('/dashboard/ingreso_mensual_actual', [HomeController::class, 'ingresoMensualActual'])->name('dashboard.ingreso_mensual_actual');

    //=================Configuracion
    Route::controller(ConfiguracionController::class)
        ->prefix('configuraciones')
        ->middleware('permission:administrador_module')
        ->group(function () {
            Route::get('/', 'index')->name('configuraciones.index');
            Route::patch('/', 'update')->name('configuraciones.update');

            //================ User // Usuarios
            Route::get('users', UserComponent::class)->name('users.index');
            Route::get('user/{uuid}', UserProfileComponent::class)->name('user.profile');
            //================ Roles and permissions // Roles y permisos
            Route::get('/roles', RolesComponent::class)->name('roles.index');
            Route::get('/permissions', PermisosComponent::class)->name('permissions.index');
            //================ Payment Methods // Metodos de pago
            Route::post('/payment_methods', [PaymentMethodComponent::class, 'save'])->name('payment_methods.store');
            Route::get('/payment_methods', PaymentMethodComponent::class)->name('payment_methods.index');
        });


    //================ Persons / Personas
    Route::group(['middleware' => 'permission:personas_module'], function () {

        //===== Persons / Personas
        Route::get('personas', [PersonasController::class, 'index'])->name('personas.index');
        // Route::get('personas', PersonaComponent::class)->name('personas.index'); // ? Se sustituyo por personas controller para evitar la logica livewire polimorfica
        Route::get('personas/create', PersonaFormComponent::class)->name('personas.create');
        Route::get('personas/edit/{uuid}', PersonaFormComponent::class)->name('personas.edit');
        //===== Partners / Socios
        Route::get('socios', SocioComponent::class)->name('socios.index');
        Route::get('socios/create', SocioFormComponent::class)->name('socios.create');
        Route::get('socios/edit/{uuid}', SocioFormComponent::class)->name('socios.edit');
        //===== Specialists / Tecnicos
        Route::get('tecnicos', TecnicoComponent::class)->name('tecnicos.index');
        Route::get('tecnicos/create', TecnicoFormComponent::class)->name('tecnicos.create');
        Route::get('tecnicos/edit/{uuid}', TecnicoFormComponent::class)->name('tecnicos.edit');
        //===== Sellers / Vendedores
        Route::get('vendedores', VendedorComponent::class)->name('vendedores.index');
        Route::get('vendedores/create', VendedorFormComponent::class)->name('vendedores.create');
        Route::get('vendedores/edit/{uuid}', VendedorFormComponent::class)->name('vendedores.edit');
    });

    //================ Clients / Clientes
    Route::group(['middleware' => 'permission:clientes_module'], function () {
        //===== Companies / Empresas
        Route::get('empresas', EmpresaComponent::class)->name('empresas.index');
        Route::get('empresas/create', EmpresaFormComponent::class)->name('empresas.create');
        Route::get('empresas/edit/{uuid}', EmpresaFormComponent::class)->name('empresas.edit');
        //===== Clients / Clientes
        Route::get('clientes', ClienteComponent::class)->name('clientes.index');
        Route::get('clientes/create', [ClienteController::class, 'create'])->name('clientes.create');
        Route::get('clientes/edit/{uuid}', [ClienteController::class, 'edit'])->name('clientes.edit');
        //===== Providers / Proveedores
        Route::get('proveedores', ProveedorComponent::class)->name('proveedores.index');
        Route::get('proveedores/create', ProveedorFormComponent::class)->name('proveedores.create');
        Route::get('proveedores/edit/{uuid}', ProveedorFormComponent::class)->name('proveedores.edit');
    });

    //================ Mikrotik satelital
    Route::group(['middleware' => 'permission:mikrotik_module'], function () {
        //===== Mikrotiks modelos
        Route::get('mikrotiks/modelos', ModeloMikrotikComponent::class)->name('mikrotiks.modelos.index');
        //===== Mikrotiks protocolos
        Route::get('mikrotiks/protocolos', ProtocoloMikrotikComponent::class)->name('mikrotiks.protocolos.index');
        //===== Mikrotiks
        Route::get('mikrotiks', MikrotikComponent::class)->name('mikrotiks.index');
        Route::get('mikrotiks/create', MikrotikFormComponent::class)->name('mikrotiks.create');
        Route::get('mikrotiks/edit/{uuid}', MikrotikFormComponent::class)->name('mikrotiks.edit');
    });

    //================ Remotas satelital / remotas
    Route::group(['middleware' => 'permission:remota_satelital_module'], function () {
        //===== Plans / Planes
        Route::get('planes', PlanComponent::class)->name('planes.index');
        Route::get('planes/create', PlanFormComponent::class)->name('planes.create');
        Route::get('planes/edit/{uuid}', PlanFormComponent::class)->name('planes.edit');
        //===== Remotas
        Route::get('remotas', RemotaComponent::class)
            ->middleware('permission:remotas_satelital.index')
            ->name('remotas.index');
        Route::get('remotas/create', [RemotasController::class, 'create'])
            ->middleware('permission:remotas_satelital.create')
            ->name('remotas.create');
        Route::post('remotas/store', [RemotasController::class, 'store'])
            ->middleware('permission:remotas_satelital.create')
            ->name('remotas.store');
        Route::get('remotas/show/{id}', [RemotasController::class, 'show'])
            // ->middleware('permission:remotas_satelital.show')
            ->name('remotas.show');
        Route::get('remotas/edit/{uuid}', [RemotasController::class, 'edit'])
            ->middleware('permission:remotas_satelital.edit')
            ->name('remotas.edit');
        Route::post('remotas/update/{id}', [RemotasController::class, 'update'])
            ->middleware('permission:remotas_satelital.edit')
            ->name('remotas.update');
    });

    //================ Cobranzas
    Route::group(['middleware' => 'permission:cobranzas_module'], function () {
        //===== Cobranzas
        Route::get('cobros', CobrosComponent::class)
            ->middleware('permission:cobranzas.cobros_particulares.index')
            ->name('cobros.index');
        Route::get('cobranzas/create', CobranzaFormComponent::class)
            ->middleware('permission:cobranzas.cobros_particulares.agregar')
            ->name('cobranzas.create');
        Route::get('cobranzas/edit/{uuid}', CobranzaFormComponent::class)->name('cobranzas.edit');
        Route::get('cobranzas/store', [CobranzaFormComponent::class, 'store'])->name('cobranzas.store');
        //==Cobros mensualidades
        Route::get('cobros_mensualidades', CobrosMensualidadesComponent::class)
            ->middleware('permission:cobranzas.cobros_mensualidades.index')
            ->name('cobros_mensualidades.index');
        //==Cobros mensualidades futuras
        Route::get('cobros_mensualidades_futuras', CobrosMensualidadesFuturasComponent::class)
            ->middleware('permission:cobranzas.cobros_mensualidades_futuras.index')
            ->name('cobros_mensualidades_futuras.index');
        //==Previsiones de recarga de cuentas
        Route::get('previsiones_de_pago', PrevisionesDePagoComponent::class)
            ->middleware('permission:cobranzas.previsiones_de_pago.index')
            ->name('previsiones_de_pago.index');
        //===== Historial de pagos en cobranzas(cobros)
        Route::get('cobros_historial', CobrosHistorialComponent::class)
            ->middleware('permission:cobranzas.historial_de_pagos_de_cobros.index')
            ->name('cobros_historial.index');
        //===== Recibos de pago
        Route::get('recibos/{id}/descargar', [ReciboCobranzaController::class, 'generarRecibo'])
            ->middleware('permission:cobranzas.historial_de_pagos_de_cobros.index')
            ->name('recibos.descargar');
        Route::get('recibos/{id}/ver', [ReciboCobranzaController::class, 'verRecibo'])
            ->middleware('permission:cobranzas.historial_de_pagos_de_cobros.index')
            ->name('recibos.ver');
        
        // Generar Factura de Mensualidad (Pendiente)
        Route::get('cobros_mensualidades/{id}/factura', [ReciboCobranzaController::class, 'generarFacturaMensualidad'])
           ->name('cobros_mensualidades.factura');
        //===== Reportes
        Route::get('reporte_vendedores', [ReportesController::class, 'vendedores_index'])->middleware('permission:cobranzas.reporte_de_vendedores.index')->name('reporte_vendedores.index');
        Route::get('reporte_vendedores/pdf', [ReportesController::class, 'vendedores_pdf'])->name('reporte_vendedores.pdf');
        // Route::get('reporte_clientes', [ReportesController::class, 'clientes_index'])->middleware('permission:cobranzas.reporte_de_clientes.index')->name('reporte_clientes.index');
        Route::get('reporte_clientes/pdf', [ReportesController::class, 'clientes_pdf'])->name('reporte_clientes.pdf');
        Route::get('reportes/cobranzas/pdf', [ReportesController::class, 'cobranzas_pdf'])->name('reporte_cobranzas.pdf');
        Route::post('reportes/cobranzas/gerencial/pdf', [ReportesController::class, 'gerencial_pdf'])->name('reporte_gerencial.pdf');
    });
});
