<x-app-layout>

    <div>
        @section('title', 'Cobranzas')


        <div class=" d-flex flex-column">

            <header class="mb-0">
                <h1 class="text-center mb-0 ">Reportes</h1>
            </header>

            <div class="d-flex justify-content-between">
                {{-- <input class="form-control list-search mw-300px mb-5" wire:model.live="search" type="search"
                    placeholder="Search"> --}}

                {{-- <a class="btn btn-primary align-self-end mb-4" href="{{ route('cobranzas.create') }}">Agregar</a>
                --}}


            </div>
            <hr>

            <div class="row ">
                <div class="card">
                    <div class="card-header">
                        Reporte de Vendedores
                    </div>
                    <div class="card-body">

                        <form action="{{ route('reporte_vendedores.pdf') }}" method="GET" class="row g-3"
                            id="formCobranza">

                            {{-- Vendedor // vendedor_uuid--}}
                            <div class="col-m-3 col-sm-3 ">
                                <label for="vendedor_id" class="col-form-label">Vendedor</label>

                                <select class="form-select" id="vendedor_id" name="vendedor_id" required>
                                    <option value="" disabled selected>Seleccione una opción</option>
                                    @foreach ($vendedores as $vendedor)
                                    @if (old('vendedor_id')==$vendedor->id)
                                    <option value="{{ $vendedor->id }}" selected>
                                        {{ $vendedor->persona->nombres }}
                                    </option>

                                    @else
                                    <option value="{{ $vendedor->id }}">
                                        {{ $vendedor->persona->nombres }}
                                    </option>

                                    @endif
                                    @endforeach
                                </select>
                                <small class="text-danger">
                                    @error('vendedor_id')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                            {{-- Estado de remota // status--}}
                            @php
                            $statuses = App\Models\Remota::getStatuses()
                            @endphp
                            <div class="col-m-2 col-sm-3 ">
                                <label for="status_remota" class="col-form-label">Estado de remota</label>

                                <select class="form-select" id="status_remota" name="status_remota" required>
                                    <option value="todas" {{ old('status_remota') == 'todas' ? 'selected' : '' }}>
                                        Todas
                                    </option>
                                    @foreach ($statuses as $status)
                                        <option value="{{ $status }}" {{ old('status_remota') == $status ? 'selected' : '' }}>
                                            {{ $status }}
                                        </option>
                                    @endforeach
                                </select>
                                <small class="text-danger">
                                    @error('status_remota')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                            {{-- fecha_desde--}}
                            <div class="col-md-2 col-sm-3 ">
                                <label for="fecha_desde" class="col-form-label">Fecha desde</label>

                                <input type="text" class="form-control" data-flatpickr id="fecha_desde"
                                    name="fecha_desde"
                                    placeholder="Ingrese la fecha desde donde se quiere hacer el reporte" required>
                                <small class="text-danger">
                                    @error('fecha_desde')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                            {{-- fecha_hasta--}}
                            <div class="col-md-2 col-sm-3 ">
                                <label for="fecha_hasta" class="col-form-label">Fecha Hasta</label>

                                <input type="text" class="form-control" data-flatpickr id="fecha_hasta"
                                    name="fecha_hasta"
                                    placeholder="Ingrese la fecha hasta donde se quiere hacer el reporte" required>
                                <small class="text-danger">
                                    @error('fecha_hasta')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                            <div class="col-md-2 col-sm-3  ">
                                <label for="" class="col-form-label">&nbsp; </label>
                                <button type="submit" class="btn btn-primary form-control ">Generar</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
            <div class="row ">
                <div class="card">
                    <div class="card-header">
                        Reporte por Cliente
                    </div>
                    <div class="card-body">

                        <form action="{{ route('reporte_clientes.pdf') }}" method="GET" class="row g-3"
                            id="formCobranza">

                            {{-- Cliente // cliente_uuid--}}
                            <div class="col-m-3 col-sm-3 ">
                                <label for="cliente_id" class="col-form-label">Cliente</label>

                                <select class="form-select" id="cliente_id" name="cliente_id" required>
                                    <option value="" disabled selected>Seleccione una opción</option>
                                    @foreach ($clientes as $cliente)
                                    @if (old('cliente_id')==$cliente->id)
                                    <option value="{{ $cliente->id }}" selected>
                                        {{ $cliente->getClientName() }}
                                    </option>

                                    @else
                                    <option value="{{ $cliente->id }}">
                                        {{ $cliente->getClientName() }}
                                    </option>

                                    @endif
                                    @endforeach
                                </select>
                                <small class="text-danger">
                                    @error('cliente_id')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>

                            {{-- fecha_desde--}}
                            <div class="col-md-2 col-sm-3 ">
                                <label for="fecha_desde" class="col-form-label">Fecha desde</label>

                                <input type="text" class="form-control" data-flatpickr id="fecha_desde"
                                    name="fecha_desde"
                                    placeholder="Ingrese la fecha desde donde se quiere hacer el reporte" required>
                                <small class="text-danger">
                                    @error('fecha_desde')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                            {{-- fecha_hasta--}}
                            <div class="col-md-2 col-sm-3 ">
                                <label for="fecha_hasta" class="col-form-label">Fecha Hasta</label>

                                <input type="text" class="form-control" data-flatpickr id="fecha_hasta"
                                    name="fecha_hasta"
                                    placeholder="Ingrese la fecha hasta donde se quiere hacer el reporte" required>
                                <small class="text-danger">
                                    @error('fecha_hasta')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                            <div class="col-md-2 col-sm-3  ">
                                <label for="" class="col-form-label">&nbsp; </label>
                                <button type="submit" class="btn btn-primary form-control ">Generar</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
            <div class="row ">
                <div class="card">
                    <div class="card-header">
                        Reporte de Cobranzas
                    </div>
                    <div class="card-body">

                        <form action="{{ route('reporte_cobranzas.pdf') }}" method="GET" class="row g-3"
                            id="formCobranza">

                            <div class="col col-md-3 col-sm-3 ">
                                <label for="status_remota" class="col-form-label">Estado de remota</label>

                                <select class="form-select" id="status_remota" name="status_remota" required>
                                    @foreach ($statuses as $status)
                                    @if (old('status_remota')==$status)
                                    <option value="todas" selected>
                                        Todas
                                    </option>

                                    @else
                                    <option value="{{ $status }}">
                                        {{ $status }}
                                    </option>

                                    @endif
                                    @endforeach
                                </select>
                                <small class="text-danger">
                                    @error('status_remota')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                            {{-- fecha_desde--}}
                            <div class="col col-md-3 col-sm-3 ">
                                <label for="fecha_desde" class="col-form-label">Fecha desde</label>

                                <input type="text" class="form-control" data-flatpickr id="fecha_desde"
                                    name="fecha_desde"
                                    placeholder="Ingrese la fecha desde donde se quiere hacer el reporte" required>
                                <small class="text-danger">
                                    @error('fecha_desde')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                            {{-- fecha_hasta--}}
                            <div class="col col-md-3 col-sm-3 ">
                                <label for="fecha_hasta" class="col-form-label">Fecha Hasta</label>

                                <input type="text" class="form-control" data-flatpickr id="fecha_hasta"
                                    name="fecha_hasta"
                                    placeholder="Ingrese la fecha hasta donde se quiere hacer el reporte" required>
                                <small class="text-danger">
                                    @error('fecha_hasta')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>

                            <div class="col col-md-3 col-sm-3 col align-self-end ">
                                <label for="" class="col-form-label float-end">&nbsp; </label>
                                <button type="submit" class="btn btn-primary form-control ">Generar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="row ">
                <div class="card">
                    <div class="card-header">
                        Reporte Gerencial
                    </div>
                    <div class="card-body">

                        <form action="{{ route('reporte_gerencial.pdf') }}" method="POST" class="row g-3"
                            id="formCobranza">
                            @csrf

                            {{-- Statuses --}}
                            <div class="col col-md-3 col-sm-3 ">
                                <label for="status_remota" class="col-form-label">Estado de remota</label>

                                <select class="form-select" id="status_remota" name="status_remota" required>
                                    @foreach ($statuses as $status)
                                    @if (old('status_remota')==$status)
                                    <option value="todas" selected>
                                        Todas
                                    </option>

                                    @else
                                    <option value="{{ $status }}">
                                        {{ $status }}
                                    </option>

                                    @endif
                                    @endforeach
                                </select>
                                <small class="text-danger">
                                    @error('status_remota')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                            {{-- fecha_desde--}}
                            <div class="col col-md-3 col-sm-3 ">
                                <label for="fecha_desde" class="col-form-label">Fecha desde</label>

                                <input type="text" class="form-control" data-flatpickr id="fecha_desde"
                                    name="fecha_desde"
                                    placeholder="Ingrese la fecha desde donde se quiere hacer el reporte" required>
                                <small class="text-danger">
                                    @error('fecha_desde')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                            {{-- fecha_hasta--}}
                            <div class="col col-md-3 col-sm-3 ">
                                <label for="fecha_hasta" class="col-form-label">Fecha Hasta</label>

                                <input type="text" class="form-control" data-flatpickr id="fecha_hasta"
                                    name="fecha_hasta"
                                    placeholder="Ingrese la fecha hasta donde se quiere hacer el reporte" required>
                                <small class="text-danger">
                                    @error('fecha_hasta')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>

                            <div class="col col-md-3 col-sm-3 col align-self-end ">
                                <label for="" class="col-form-label float-end">&nbsp; </label>
                                <button type="submit" class="btn btn-primary form-control ">Generar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>






            {{-- @include('livewire.cobranza.modal.index') --}}


        </div>
        <div class="d-flex justify-content-center">
            {{-- {{ $cobranzas->links() }} --}}
        </div>
    </div>
    <script src="{{ asset('assets/js/theme.bundle.js') }}"></script>

</x-app-layout>
