<div class="card-body row mb-4">
    {{-- Informacion tecnica de antena --}}

    <p class="text-center h4 m-0 ">Informacion tecnica de antena </p>

    {{-- Nombre del equipo // equipo --}}
    <div class="col-sm-6 col-lg-4">
        <label for="nombre_equipo" class="col-form-label">Nombre del equipo</label>

        <input class="form-control" id="nombre_equipo" name="nombre_equipo" placeholder="Ingrese el nombre del equipo"
            value="{{ old('nombre_equipo') ?? $remota->equipo }}" required @if(request()->routeIs('remotas.show'))
        readonly disabled @endif>

        <small class="text-danger">
            @error('nombre_equipo')
            {{ $message }}
            @enderror
        </small>
    </div>

    {{-- Tipo de router // tipo_router_id--}}
    {{-- Modelos_mikrotiks --}}
    <div class="col-sm-6 col-lg-4">

        <label for="tipo_router_id" class="col-form-label">Tipo de router</label>



        <select class="form-select" name="tipo_router_id" id="tipo_router_id" required
            @if(request()->routeIs('remotas.show')) disabled @endif>
            <option value="">Seleccione una opcion</option>
            @foreach ($ModelosMicrotik as $modelo_microtik)
            @if ($modelo_microtik->id == $remota->tipo_router_id ||old('tipo_router_id')==$modelo_microtik->id)
            <option value="{{ $modelo_microtik->id }}" selected>
                {{ $modelo_microtik->nombre }}
            </option>
            @else
            <option value="{{ $modelo_microtik->id }}">
                {{ $modelo_microtik->nombre }}
            </option>
            @endif
            @endforeach
        </select>
        <small class="text-danger">
            @error('tipo_router_id')
            {{ $message }}
            @enderror
        </small>

    </div>
    {{-- Puerto // puerto--}}
    <div class="col-sm-6 col-lg-4">
        <label for="puerto" class="col-form-label">Puerto</label>

        <input min="0" type="number" class="form-control" id="puerto" name="puerto"
            placeholder="Ingrese el puerto de la remota" value="{{ old('puerto') ?? $remota->puerto }}" required
            @if(request()->routeIs('remotas.show')) disabled readonly @endif/>
        <small class="text-danger">
            @error('puerto')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Ip // ip_gestion--}}
    <div class="col-sm-6 col-lg-4">
        <label for="ip_gestion" class="col-form-label">IP Gestion</label>

        <input class="form-control" id="ip_gestion" name="ip_gestion" placeholder="Ingrese IP de gestion "
            value="{{ old('ip_gestion') ??$remota->ip_gestion }}" required @if(request()->routeIs('remotas.show'))
        readonly disabled @endif>
        <small class="text-danger">
            @error('ip_gestion')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Ubicacion // ubicacion --}}
    <div class="col-sm-6 col-lg-4">
        <label for="ubicacion" class="col-form-label">Ubicacion</label>

        <input class="form-control" id="ubicacion" name="ubicacion" placeholder="Ingrese ubicacion de la remota"
            value="{{ old('ubicacion') ??$remota->ubicacion}}" required @if(request()->routeIs('remotas.show')) readonly
        disabled
        @endif>
        <small class="text-danger">
            @error('ubicacion')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Detalle o comentario // detalle--}}
    <div class="col-sm-6 col-lg-4">
        <label for="detalle" class="col-form-label">Comentario</label>

        <input class="form-control" id="detalle" name="detalle" placeholder="Comentario o detalle de la remota"
            value="{{ old('detalle') ??$remota->detalle}}" required @if(request()->routeIs('remotas.show')) readonly
        disabled
        @endif>
        <small class="text-danger">
            @error('detalle')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Zona // zona--}}
    {{-- <div class="col-sm-6 col-lg-4">
        <label for="zona" class="col-form-label">Zona</label>

        <input class="form-control" id="zona" name="zona" placeholder="Ingrese zona de la remota"
            value="{{ old('zona')??$remota->zona }}" required>
        <small class="text-danger">
            @error('zona')
            {{ $message }}
            @enderror
        </small>
    </div> --}}

    {{-- Encargado // encargado--}}
    {{-- <div class="col-sm-6 col-lg-4">
        <div>
            <label for="encargado" class="col-form-label">Encargado</label>
        </div>

        <div>
            <input class="form-control" id="encargado" name="encargado" placeholder="Encargado  de la remota"
                value="{{ old('encargado') }}" required>
            <small class="text-danger">
                @error('encargado')
                {{ $message }}
                @enderror
            </small>
        </div>
    </div> --}}

    {{-- Informacion de seriales --}}
    <hr class="mt-3">
    <p class="text-center h4 m-0 ">Informacion de seriales </p>

    {{-- Serial // serial--}}
    <div class="col-sm-6 col-lg-4">
        <label for="serial" class="col-form-label">Serial</label>

        <input class="form-control" id="serial" name="serial" placeholder="Ingrese el serial de la remota"
            value="{{ old('serial') ??$remota->serial}}" @if(request()->routeIs('remotas.show')) readonly disabled
        @endif />
        <small class="text-danger">
            @error('serial')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Kit serial // kit_serial --}}
    <div class="col-sm-6 col-lg-4">
        <label for="kit_serial" class="col-form-label">Kit Serial</label>

        <input class="form-control" id="kit_serial" name="kit_serial" placeholder="Ingrese el serial kit de la remota "
            value="{{ old('kit_serial')??$remota->kit_serial }}" required @if(request()->routeIs('remotas.show'))
        readonly disabled @endif>
        <small class="text-danger">
            @error('kit_serial')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Serial de la antena // antena_serial--}}
    <div class="col-sm-6 col-lg-4">
        <label for="antena_serial" class="col-form-label">Serial Antena</label>

        <input class="form-control" id="antena_serial" name="antena_serial" placeholder="Ingrese serial de la remota"
            value="{{ old('antena_serial') ??$remota->antena_serial}}" @if(request()->routeIs('remotas.show')) readonly
        disabled
        @endif>
        <small class="text-danger">
            @error('antena_serial"')
            {{ $message }}
            @enderror
        </small>
    </div>

    {{-- Informacion de cobro --}}
    <hr class="mt-3">
    <p class="text-center h4 m-0 ">Informacion de cobro </p>

    {{-- Dia de corte de starlink // dia_corte--}}
    <div class="col-sm-6 col-lg-4">
        <label for="dia_corte" class="col-form-label">Dia de corte</label>

        <input type="date" class="form-control" data-flatpickr id="dia_corte" name="dia_corte"
            placeholder="Ingrese el dia de corte de la remota" value="{{ old('dia_corte') ??$remota->dia_corte}}"
            required @if(request()->routeIs('remotas.show')) readonly disabled @endif>
        <small class="text-danger">
            @error('dia_corte')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Dia de activacion cliente // dia_activacion --}}
    <div class="col-sm-6 col-lg-4">
        <label for="dia_activacion" class="col-form-label">Dia de activacion cliente</label>

        <input type="date" class="form-control" id="dia_activacion" data-flatpickr name="dia_activacion"
            placeholder="Ingrese dia en que el cliente activo la remota"
            value="{{ old('dia_activacion') ??$remota->dia_activacion }}" required
            @if(request()->routeIs('remotas.show')) readonly disabled @endif>
        <small class="text-danger">
            @error('dia_activacion')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Fecha de la cuenta // fecha_cuenta--}}
    <div class="col-sm-6 col-lg-4">
        <label for="fecha_cuenta" class="col-form-label">Fecha corte cuenta</label>

        <input type="date" class="form-control" data-flatpickr id="fecha_cuenta" name="fecha_cuenta"
            placeholder="Ingrese la fecha cuando expira la cuenta "
            value="{{ old('fecha_cuenta')??$remota->fecha_cuenta }}" @if(request()->routeIs('remotas.show')) readonly
        disabled
        @endif>
        <small class="text-danger">
            @error('fecha_cuenta')
            {{ $message }}
            @enderror
        </small>
    </div>

    <div class="col-sm-12 col-lg-12">
        <div id="fechas_help" class="form-text text-center">Fechas deberian ser elegidas con
            respecto al mes actual.
        </div>

    </div>
    {{-- Método de pago // paymentmethod --}}
    <div class="col-sm-6 col-lg-4">
        <label for="paymenth_method_id" class="col-form-label">Método de pago</label>

        <select class="form-select" name="paymenth_method_id" id="paymenth_method_id" required
            @if(request()->routeIs('remotas.show')) readonly disabled @endif>
            <option value="">Seleccione una opción</option>
            @foreach ($payment_methods as $pm)
            <option value="{{ $pm->id }}" @if ($pm->id == $remota->metodo_de_pago_id || old('paymenth_method_id') ==
                $pm->id) selected @endif>
                {{ $pm->name }}
            </option>
            @endforeach
        </select>
        <small class="text-danger">
            @error('paymenth_method_id')
            {{ $message }}
            @enderror
        </small>
    </div>

    {{-- Cuenta // correo_cuenta--}}
    <div class="col-sm-6 col-lg-4">
        <label for="correo_cuenta" class="col-form-label">Correo de cuenta </label>

        <input type="email" class="form-control" id="correo_cuenta" name="correo_cuenta"
            placeholder="Ingrese correo de la cuenta " value="{{ old('correo_cuenta')??$remota->correo_cuenta }}"
            @if(request()->routeIs('remotas.show')) readonly disabled @endif>
        <small class="text-danger">
            @error('correo_cuenta')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Password Cuenta // password_correo_cuenta --}}
    <div class="col-sm-6 col-lg-4">
        <label for="password_correo_cuenta" class="col-form-label">Contraseña de cuenta </label>

        <input class="form-control" id="password_correo_cuenta" name="password_correo_cuenta"
            placeholder="Ingrese correo de la cuenta "
            value="{{ old('password_correo_cuenta') ??$remota->password_correo_cuenta }}"
            @if(request()->routeIs('remotas.show')) readonly disabled @endif>
        <small class="text-danger">
            @error('password_correo_cuenta')
            {{ $message }}
            @enderror
        </small>
    </div>

    {{-- Informacion personas --}}
    {{--Cliente // cliente_uuid--}}
    <div class="col-sm-6 col-lg-4">
        <label for="cliente_id" class="col-form-label">Cliente</label>


        <select class="form-select" name="cliente_id" id="cliente_id" required @if(request()->routeIs('remotas.show'))
            readonly disabled @endif>
            <option value="">Seleccione una opcion</option>
            @foreach ($clientes as $cliente)
            @if ($cliente->id == $remota->cliente_id ||old('cliente_id')==$cliente->id)
            <option value="{{ $cliente->id }}" selected>
                {{ $cliente->getClientName() }}
            </option>
            @else
            <option value="{{ $cliente->id }}">
                {{ $cliente->getClientName() }}
            </option>

            @endif
            @endforeach
        </select>
        <small class="text-danger">
            @error('cliente_id')
            {{ $message }}
            @enderror
        </small>
    </div>

    {{-- Proveedor // proveedor_uuid --}}
    <div class="col-sm-6 col-lg-4">
        <label for="proveedor_id" class="col-form-label">Proveedor</label>


        <select class="form-select" name="proveedor_id" id="proveedor_id" required
            @if(request()->routeIs('remotas.show')) readonly disabled @endif>
            <option value="">Seleccione una opcion</option>
            @foreach ($proveedores as $proveedor)
            @if ($proveedor->id == $remota->proveedor_id ||old('proveedor_id')==$proveedor->id)
            <option value="{{ $proveedor->id }}" selected>
                {{ $proveedor->empresa->razon }}
            </option>

            @else
            <option value="{{ $proveedor->id }}">
                {{ $proveedor->empresa->razon }}
            </option>

            @endif
            @endforeach
        </select>
        <small class="text-danger">
            @error('proveedor_uuid')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Plan // plan_uuid --}}
    <div class="col-sm-6 col-lg-4">
        <label for="plan_id" class="col-form-label">Plan</label>

        <select class="form-select" name="plan_id" id="plan_id" required @if(request()->routeIs('remotas.show'))
            readonly disabled @endif>

            <option value="">Seleccione una opcion</option>
            @foreach ($planes as $plan)
            @if ($plan->id == $remota->plan_id ||old('plan_id')==$plan->id)
            <option value="{{ $plan->id }}" selected>
                {{ $plan->nombre }}
            </option>

            @else
            <option value="{{ $plan->id }}">
                {{ $plan->nombre }}
            </option>

            @endif
            @endforeach
        </select>
        <small class="text-danger">
            @error('plan')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- costo // costo_plan--}}
    <div class="col-sm-6 col-lg-4">
        <label for="costo_plan" class="col-form-label">Costo del plan </label>

        <input type="number" class="form-control" id="costo_plan" name="costo_plan" placeholder="0"
            value="{{ old('costo_plan') ??$remota->costo }}" required @if(request()->routeIs('remotas.show')) readonly
        disabled
        @endif>
        <small class="text-danger">
            @error('costo_plan')
            {{ $message }}
            @enderror
        </small>
    </div>


    {{-- Socio
    <div class="col-sm-6 col-lg-4">
        <div>
            <label for="fullName" class="col-form-label">Socio</label>
        </div>

        <div>
            <select class="form-select" name="socio" id="socio" name="socio">
                <option value=""></option>
                @foreach ($socios as $socio)
                <option value="{{ $socio->persona->uuid }}">
                    {{ $socio->persona->nombres }}
                </option>
                @endforeach
            </select>
            <small class="text-danger">
                @error('socio')
                {{ $message }}
                @enderror
            </small>
        </div>
    </div> --}}
    {{-- Vendedor // vendedor_uuid--}}
    <div class="col-sm-6 col-lg-4">
        <label for="vendedor_id" class="col-form-label">Vendedor</label>

        <select class="form-select" id="vendedor_id" name="vendedor_id" required @if(request()->routeIs('remotas.show'))
            readonly disabled @endif>
            <option value="">Seleccione una opcion</option>
            @foreach ($vendedores as $vendedor)
            @if ($vendedor->id == $remota->vendedor_id ||old('vendedor_id')==$vendedor->id)
            <option value="{{ $vendedor->id }}" selected>
                {{ $vendedor->persona->nombres }}
            </option>

            @else
            <option value="{{ $vendedor->id }}">
                {{ $vendedor->persona->nombres }}
            </option>

            @endif
            @endforeach
        </select>
        <small class="text-danger">
            @error('vendedor_id')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Comision de vendedor --}}
    <div class="col-sm-6 col-lg-4">
        <label for="comision_vendedor" class="col-form-label">Comision de vendedor</label>

        <input type="number" class="form-control" id="comision_vendedor" name="comision_vendedor" placeholder="0"
            min="0" step="0.01" value="{{ old('comision_vendedor') ??$remota->comision }}" required
            @if(request()->routeIs('remotas.show')) readonly disabled @endif>
        <small class="text-danger">
            @error('comision_vendedor')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Estatus // status--}}
    <div class="col-sm-6 col-lg-4">
        <label for="status" class="col-form-label">Status</label>

        <select class="form-select" id="status" name="status" required @if(request()->routeIs('remotas.show')) readonly
            disabled
            @endif>
            <option value="">Seleccione una opcion</option>
            @foreach ($data['statuses'] as $status_key => $nombre)
            @if ($status_key == $remota->status ||old('status')==$status_key)
            <option value="{{ $status_key }}" selected>{{ $nombre }}</option>

            @else
            <option value="{{ $status_key }}">{{ $nombre }}</option>

            @endif

            @endforeach
        </select>
        <small class="text-danger">
            @error('status')
            {{ $message }}
            @enderror
        </small>
    </div>
    
    {{-- Licencias TicketPlus // TxtIdentity --}}
    <div class="col-sm-6 col-lg-4">
        <label for="TxtIdentity" class="col-form-label">Licencias TicketPlus</label>

        <select class="form-select" id="TxtIdentity" name="TxtIdentity" @if(request()->routeIs('remotas.show')) readonly
            disabled
            @endif>
            <option value="">Seleccione una licencia</option>
            @foreach ($licencias_Ticketplus as $txtIdentity => $licencia)
            @if ($txtIdentity == $remota->TxtIdentity || old('TxtIdentity') == $txtIdentity)
            <option value="{{ $txtIdentity }}" selected>
                {{ $txtIdentity }} ({{ $licencia['total_registros'] }} registros)
            </option>
            @else
            <option value="{{ $txtIdentity }}">
                {{ $txtIdentity }} ({{ $licencia['total_registros'] }} registros)
            </option>
            @endif
            @endforeach
        </select>
        <small class="text-danger">
            @error('TxtIdentity')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Detalles extra // detalles_extra --}}
    <div class="col-sm-12 col-lg-12">
        <label for="detalles_extra" class="col-form-label">Detalles extra</label>
        <textarea class="form-control" id="detalles_extra" name="detalles_extra" rows="3"
            placeholder="Ingrese detalles adicionales sobre la remota"
            @if(request()->routeIs('remotas.show')) readonly disabled @endif>{{ old('detalles_extra') ?? $remota->detalles_extra }}</textarea>
        <small class="text-danger">
            @error('detalles_extra')
            {{ $message }}
            @enderror
        </small>
    </div>
    {{-- Numero de contrto // puerto--}}
    {{-- <div class="col-sm-6 col-lg-4">
        <label for="meses_contrato" class="col-form-label">Meses de contrato</label>

        <input min="0" type="number" class="form-control" id="meses_contrato" name="meses_contrato"
            placeholder="Ingrese meses de contrato que tiene la remota"
            value="{{ old('meses_contrato') ??$remota->meses_contrato }}" required />
        <small class="text-danger">
            @error('meses_contrato')
            {{ $message }}
            @enderror
        </small>
    </div> --}}

    <div class="d-flex justify-content-end gap-2 mt-4">
        <!-- Button -->
        {{-- @if ($uuid)
        <button type="button" wire:click="resetForm" class="btn btn-danger">Reiniciar</button>
        @else
        <button type="button" wire:click="cleanForm" class="btn btn-danger">Limpiar</button>
        @endif --}}
        <button type="submit" class="btn btn-primary @if(request()->routeIs('remotas.show')) d-none disabled @endif">{{
            __('Save') }}</button>
    </div>
</div>