<x-app-layout>

    <div>
        @section('title', $metadatos['title'])
        <div class="col">
            <form action="{{ route($metadatos['routes_key'].'.store') }}" method="GET">
                <!-- Card -->
                <div class="card border-0 scroll-mt-3" id="basicInformationSection">
                    <div class="d-flex justify-content-end p-2">
                        {{ $toolbar ?? '' }}
                        {{-- Boton de cargar --}}
                    </div>
                    <div class="card-header">
                        <h2 class="h3 mb-0 text-center">{{ $metadatos['title'] }}</h2>
                    </div>

                    <div class="card-body row mb-4">
                        {{-- Nombres --}}
                        <div class="col-md-6">

                            <label for="nombres" class="form-label">Nombres</label>
                            <input class="form-control" type="text" id="nombres" name="nombres"
                                placeholder="Ingrese los nombres de la persona" required>
                            <small class="text-danger">
                                @error('form.nombres')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>

                        {{-- Cedula --}}
                        <div class="col-md-6 mb-4">
                            <label for="cedula" class="form-label">Cedula</label>
                            <div class="input-group">
                                <select class="form-select " name="nacionalidad" id="nacionalidad"
                                    aria-describedby="inputGroupPrepend">
                                    <option value="V" selected>V</option>
                                    <option value="E">E</option>
                                </select>
                                <input class="form-control rounded-end" type="text" id="cedula" name="numero_cedula"
                                    aria-describedby="inputGroupPrepend" placeholder="Ingrese documento de indentidad">
                                <small class="text-danger">
                                    @error('form.nacionalidad')
                                    {{ $message }}
                                    @enderror
                                </small>
                                <small class="text-danger">
                                    @error('form.cedula')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div>

                        {{-- Direccion --}}
                        <div class="col-md-12 mb-4">
                            <label for="direccion" class="form-label">Dirección</label>
                            <input class="form-control" type="text" id="direccion" name="numero_cedula"
                                placeholder="Ingrese direccion de la persona">
                            <small class="text-danger">
                                @error('form.direccion')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                        {{-- Telefono --}}
                        <div class="col-md-4 mb-4">
                            <label for="telefono" class="form-label">Teléfono</label>
                            <input class="form-control" type="tel" id="telefono" name="telefono"
                                placeholder="Ingrese telefono de la persona" required>
                            <small class="text-danger">
                                @error('form.telefono')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>

                        {{-- Telefono secundario --}}
                        <div class="col-md-4 mb-4">
                            <label for="telefono_secundario" class="form-label">Teléfono secundario</label>
                            <input class="form-control" type="tel" id="telefono_secundario" name="telefono_secundario"
                                placeholder="Ingrese telefono secundario de la persona">
                            <small class="text-danger">
                                @error('form.telefono_secundario')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>

                        {{-- Whatsapp --}}
                        <div class="col-md-4 mb-4">
                            <label for="whatsapp" class="form-label">Whatsapp</label>
                            <input class="form-control" type="tel" id="whatsapp" name="whatsapp"
                                placeholder="Ingrese numero de telefono asociado whatsapp de la persona">
                            <small class="text-danger">
                                @error('form.whatsapp')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>

                        {{-- Telegram --}}
                        <div class="col-md-4 mb-4">
                            <label for="telegram" class="form-label">Telegram</label>
                            <input class="form-control" type="tel" id="telegram" name="telegram"
                                placeholder="Ingrese usuario de telegram">
                            <small class="text-danger">
                                @error('form.telegram')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>

                        {{-- Correo --}}
                        <div class="col-md-4 mb-4">
                            <label for="correo" class="form-label">Correo</label>
                            <input class="form-control" type="email" id="correo" name="correo"
                                placeholder="Ingrese correo de la persona">
                            <small class="text-danger">
                                @error('form.telegram')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>

                        <div class="d-flex justify-content-end gap-2">
                            <!-- Button -->
                            {{-- @if ($uuid)
                            <button type="button" wire:click="resetForm" class="btn btn-danger">Reiniciar</button>
                            @else
                            <button type="button" wire:click="cleanForm" class="btn btn-danger">Limpiar</button>
                            @endif
                            --}}
                            <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                        </div>
                    </div>

                </div>

            </form>
        </div>



    </div>



</x-app-layout>