<div>
    @section('title', 'Perfil Usuario ' . $this->user->name)

    <div class="col">
        <form wire:submit="save">

            <!-- Card -->
            <div class="card border-0 scroll-mt-3" id="basicInformationSection">
                <div class="card-header">
                    <h2 class="h3 mb-0">{{ __('Basic information') }}</h2>
                </div>

                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-lg-3">
                            <label for="fullName" class="col-form-label">{{ __('Full Name') }}</label>
                        </div>

                        <div class="col-lg">
                            <input type="text" class="form-control" name="name" wire:model="form.nombre">
                            <small class="text-danger">
                                @error('form.nombre')
                                    {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div> <!-- / .row -->

                    <div class="row mb-4">
                        <div class="col-lg-3">
                            <label for="emailAddress" class="col-form-label">{{ __('Email Address') }}</label>
                        </div>

                        <div class="col-lg">
                            <input type="text" class="form-control" name="email" wire:model="form.email">
                        </div>
                        <small class="text-danger">
                            @error('form.email')
                                {{ $message }}
                            @enderror
                        </small>
                    </div> <!-- / .row -->

                    <div class="d-flex justify-content-end mt-5">

                        <!-- Button -->
                        <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                    </div>
                </div>
            </div>

            <!-- Card -->
            <div class="card border-0 scroll-mt-3" id="passwordSection">
                <div class="card-header">
                    <h2 class="h3 mb-0">Password</h2>
                </div>

                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-lg-3">
                            <label for="currentPassword" class="col-form-label">{{ __('Current Password') }}</label>
                        </div>

                        <div class="col-lg">
                            <input type="password" class="form-control" name="currentPassword" wire:model="form.currentPassword" autocomplete="new-password">
                        </div>
                        <small class="text-danger">
                            @error('form.currentPassword')
                                {{ $message }}
                            @enderror
                        </small>
                    </div> <!-- / .row -->

                    <div class="row mb-4">
                        <div class="col-lg-3">
                            <label for="newPassword" class="col-form-label">{{ __('New Password') }}</label>
                        </div>

                        <div class="col-lg">
                            <div class="input-group input-group-merge">
                                <input type="password" class="form-control" name="newPassword" wire:model="form.newPassword" autocomplete="off" data-toggle-password-input placeholder="{{ __('Your New Password') }}">
                                <button type="button" class="input-group-text px-4 text-secondary link-primary" data-toggle-password></button>
                            </div>
                            <small class="text-danger">
                                @error('form.newPassword')
                                    {{ $message }}
                                @enderror
                            </small>
                        </div>

                        <div class="col-lg">
                            <div class="input-group input-group-merge">
                                <input type="password" class="form-control" name="newPasswordAgain" wire:model="form.passwordConfirm" autocomplete="off" data-toggle-password-input placeholder="{{ __('Confirm Password') }}">
                                <button type="button" class="input-group-text px-4 text-secondary link-primary" data-toggle-password></button>
                            </div>
                            <small class="text-danger">
                                @error('form.passwordConfirm')
                                    {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div> <!-- / .row -->

                    <div class="d-flex justify-content-end mt-5">

                        <!-- Button -->
                        <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                    </div>
                </div>
            </div>

        </form>
    </div>

</div>
