<button x-on:show-modal.window="document.querySelector('[data-bs-target=\'#registerModal\']').click()" type="button"
    class="btn btn-primary align-self-end mb-4" data-bs-toggle="modal" data-bs-target="#registerModal">
    Agregar
</button>

<div wire:ignore.self class="modal fade" data-bs-backdrop='static' id="registerModal" tabindex="-1" aria-labelledby="registerModalLabel"
    aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form wire:submit="save">
                <div class="modal-header">
                    <h3 class="modal-title" id="registerModalLabel">{{ $modalTitle }}</h3>
                    <button x-on:hide-modal.window="document.getElementById('btn-close-modal-register').click();"
                        id="btn-close-modal-register" type="button" class="btn-close" data-bs-dismiss="modal"
                        x-on:click="$wire.cancel()"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div>
                        <label class="form-label" for="nombre">Nombre</label>
                        <input id=nombre type="text" class="form-control" wire:model="nombre" autocomplete="off">
                        <small class="text-danger">
                            @error('nombre')
                                {{ $message }}
                            @enderror
                        </small>
                    </div>
                    <div>
                        <label class="form-label" for="email">Email</label>
                        <input type="email" id="email" class="form-control" wire:model="email" autocomplete="off">
                        <small class="text-danger">
                            @error('email')
                                {{ $message }}
                            @enderror
                        </small>
                    </div>
                    <div>
                        <label class="form-label" for="password">Contraseña</label>
                        <input type="password" id="password" class="form-control" wire:model="password"
                            autocomplete="new-password">
                        <small class="text-danger">
                            @error('email')
                                {{ $message }}
                            @enderror
                        </small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" x-on:click="$wire.cancel()" class="btn btn-light"
                        data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary btn-send">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>
