<button x-on:show-detail.window="document.querySelector('[data-bs-target=\'#detailRemotaModal\']').click()"
    type="button" data-bs-toggle="modal" data-bs-target="#detailRemotaModal" class="d-none"></button>

<div wire:ignore.self class="modal fade" id="detailRemotaModal" tabindex="-1" aria-labelledby="detailRemotaModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title" id="detailRemotaModalLabel">{{ $modalTitle }}</h3>
                <button x-on:hide-modal.window="document.getElementById('btn-close-modal-register').click();"
                    id="btn-close-modal-register" type="button" class="btn-close" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="col">
                    <!-- Card -->
                    <ul class="nav nav-tabs" id="remotaDetailTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <a class="nav-link active" id="information-tab" data-bs-toggle="tab" href="#information"
                                role="tab" aria-controls="information" aria-selected="true">Roles asignados</a>
                        </li>

                    </ul>
                    <div class="border-0 scroll-mt-3 tab-content">
                        @if ($roles != null)
                        <div class="row">
                            <form wire:submit.prevent="syncRoles">

                                @forelse ($roles as $rol)
                                <div class="col-md-1">
                                    <div class="form-check mt-5">
                                        <input type="checkbox" class="form-check-input" value="{{ $rol->name }}"
                                            id="rol_{{ $rol->id }}" {{ $user_info->hasRole($rol->name) ?'checked':'' }}
                                        wire:model="RolesSeleccionados"
                                        >
                                        <label for="rol_{{ $rol->id }}" class="form-check-label">{{ $rol->name
                                            }}</label>
                                    </div>

                                </div>

                                @empty
                                "No hay roles registrados"
                                @endforelse
                                <button type="submit" class="btn btn-primary align-self-end mb-4">Asignar</button>
                            </form>


                        </div>

                        @endif
                        {{-- @include('livewire.remota.modal.remota')
                        @include('livewire.remota.modal.cliente')
                        @include('livewire.remota.modal.vendedor')
                        @include('livewire.remota.modal.plan')
                        @include('livewire.remota.modal.socio') --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>