<div>
    @section('title', $pageTitle)

    <div class="col">
        <form wire:submit="save">
            <!-- Card -->
            <div class="card border-0 scroll-mt-3" id="basicInformationSection">
                <div class="card-header">
                    <h2 class="h3 mb-0 text-center">{{ $pageTitle }}</h2>
                </div>

                <div class="card-body row mb-4">
                    {{-- Informacion tecnica de antena --}}

                    <p class="text-center h4 m-0 ">Informacion tecnica de antena </p>

                    {{-- Nombre del equipo // equipo --}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="equipo" class="col-form-label">Nombre del equipo</label>
                        </div>

                        <div>
                            <input class="form-control" id="equipo" wire:model="form.equipo"
                                placeholder="Ingrese el nombre del equipo">
                            <small class="text-danger">
                                @error('form.equipo')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Tipo de router // tipo_router--}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="tipo_router" class="col-form-label">Tipo de router</label>
                        </div>

                        <div>
                            <input min="0" type="text" class="form-control" id="tipo_router"
                                wire:model="form.tipo_router" placeholder="Ingrese el tipo_router" />
                            <small class="text-danger">
                                @error('form.tipo_router')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Puerto // puerto--}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="puerto" class="col-form-label">Puerto</label>
                        </div>

                        <div>
                            <input min="0" type="number" class="form-control" id="puerto" wire:model="form.puerto"
                                placeholder="Ingrese el puerto de la remota" />
                            <small class="text-danger">
                                @error('form.puerto')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Ip // ip_gestion--}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="ip_gestion" class="col-form-label">IP Gestion</label>
                        </div>

                        <div>
                            <input class="form-control" id="ip_gestion" wire:model="form.ip_gestion"
                                placeholder="Ingrese IP de gestion ">
                            <small class="text-danger">
                                @error('form.ip_gestion')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Ubicacion // ubicacion --}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="ubicacion" class="col-form-label">Ubicacion</label>
                        </div>

                        <div>
                            <input class="form-control" id="ubicacion" wire:model="form.ubicacion"
                                placeholder="Ingrese ubicacion de la remota">
                            <small class="text-danger">
                                @error('form.ubicacion')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Detalle // detalle--}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="detalle" class="col-form-label">Comentario</label>
                        </div>

                        <div>
                            <input class="form-control" id="detalle" wire:model="form.detalle"
                                placeholder="Comentario o detalle de la remota">
                            <small class="text-danger">
                                @error('form.detalle')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Zona // zona--}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="zona" class="col-form-label">Zona</label>
                        </div>

                        <div>
                            <input class="form-control" id="zona" wire:model="form.zona"
                                placeholder="Ingrese zona de la remota">
                            <small class="text-danger">
                                @error('form.zona')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Encargado // encargado--}}
                    {{-- <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="encargado" class="col-form-label">Encargado</label>
                        </div>

                        <div>
                            <input class="form-control" id="encargado" wire:model="form.encargado"
                                placeholder="Encargado  de la remota">
                            <small class="text-danger">
                                @error('form.encargado')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div> --}}

                    {{-- Informacion de seriales --}}
                    <hr class="mt-3">
                    <p class="text-center h4 m-0 ">Informacion de seriales </p>

                    {{-- Serial // serial--}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="serial" class="col-form-label">Serial del router</label>
                        </div>

                        <div>
                            <input class="form-control" id="serial" wire:model="form.serial"
                                placeholder="Ingrese el serial de la remota" />
                            <small class="text-danger">
                                @error('form.serial')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Kit serial // kit_serial --}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="kit_serial" class="col-form-label">Kit Serial</label>
                        </div>

                        <div>
                            <input class="form-control" id="kit_serial" wire:model="form.kit_serial"
                                placeholder="Ingrese el serial kit de la remota ">
                            <small class="text-danger">
                                @error('form.kit_serial')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Serial de la antena // antena_serial--}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="antena_serial" class="col-form-label">Serial Antena</label>
                        </div>

                        <div>
                            <input class="form-control" id="antena_serial" wire:model="form.antena_serial"
                                placeholder="Ingrese serial de la remota">
                            <small class="text-danger">
                                @error('form.antena_serial"')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>

                    {{-- Informacion de cobro --}}
                    <hr class="mt-3">
                    <p class="text-center h4 m-0 ">Informacion de cobro </p>

                    {{-- Dia de corte de starlink // dia_corte--}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="dia_corte" class="col-form-label">Dia de corte</label>
                        </div>

                        <div>
                            <input type="text" class="form-control" data-flatpickr id="dia_corte"
                                wire:model="form.dia_corte" placeholder="Ingrese el dia de corte de la remota">
                            <small class="text-danger">
                                @error('form.dia_corte')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Dia de activacion cliente // dia_activacion --}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="dia_activacion" class="col-form-label">Dia de activacion cliente</label>
                        </div>


                        <div>
                            <input class="form-control" id="dia_activacion" data-flatpickr
                                wire:model="form.dia_activacion"
                                placeholder="Ingrese dia en que el cliente activo la remota">
                            <small class="text-danger">
                                @error('form.dia_activacion')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Cuenta // correo_cuenta--}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="correo_cuenta" class="col-form-label">Correo de cuenta </label>
                        </div>

                        <div>
                            <input type="email" class="form-control" id="correo_cuenta" wire:model="form.correo_cuenta"
                                placeholder="Ingrese correo de la cuenta ">
                            <small class="text-danger">
                                @error('form.correo_cuenta')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Password Cuenta // password_correo_cuenta --}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="password_correo_cuenta" class="col-form-label">Contraseña de cuenta </label>
                        </div>

                        <div>
                            <input class="form-control" id="password_correo_cuenta"
                                wire:model="form.password_correo_cuenta" placeholder="Ingrese correo de la cuenta ">
                            <small class="text-danger">
                                @error('form.password_correo_cuenta')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Fecha de la cuenta // fecha_cuenta--}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="fecha_cuenta" class="col-form-label">Fecha de la cuenta</label>
                        </div>

                        <div>
                            <input class="form-control" id="fecha_cuenta" data-flatpickr wire:model="form.fecha_cuenta"
                                placeholder="Fecha de corte de la cuenta ">
                            <small class="text-danger">
                                @error('form.fecha_cuenta')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>

                    {{-- Informacion personas --}}
                    {{--Cliente // cliente_uuid--}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="cliente_uuid" class="col-form-label">Cliente</label>
                        </div>

                        <div>
                            <select class="form-select" name="cliente_uuid" id="cliente_uuid"
                                wire:model="form.cliente_uuid" placeholder>
                                <option value="">Seleccione una opcion</option>
                                @foreach ($clientes as $cliente)
                                <option value="{{ $cliente->uuid }}">
                                    {{ $cliente->getClientName() }}

                                </option>
                                @endforeach
                            </select>
                            <small class="text-danger">
                                @error('form.cliente_uuid')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>


                    {{-- Proveedor y plan --}}
                    {{-- @livewire('proveedor-plan-select') --}}

                    {{-- Proveedor // proveedor_uuid --}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="proveedor_uuid" class="col-form-label">Proveedor</label>
                        </div>

                        <div>
                            <select class="form-select" name="proveedor_uuid" id="proveedor"
                                wire:model="form.proveedor_uuid">
                                <option value="">Seleccione una opcion</option>
                                @foreach ($proveedores as $proveedor)
                                <option value="{{ $proveedor->id }}">
                                    {{ $proveedor->empresa->razon }}
                                </option>
                                @endforeach
                            </select>
                            <small class="text-danger">
                                @error('form.proveedor_uuid')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Plan // plan_uuid --}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="plan_uuid" class="col-form-label">Plan</label>
                        </div>

                        {{-- <select class="form-select" name="plan_uuid" id="plan" --}} <div>
                            <select class="form-select" name="plan_uuid" id="plan" wire:model="form.plan_uuid">
                                @if ($planes->count() == 0)
                                <option value="">Debe seleccionar un proveedor opcion</option>
                                @endif
                                @foreach ($planes as $plan)
                                <option value="{{ $plan->uuid }}">
                                    {{ $plan->nombre }}
                                </option>
                                @endforeach
                            </select>
                            <small class="text-danger">
                                @error('form.plan_uuid')
                                {{ $message }}
                                @enderror
                            </small>
                    </div>
                </div>
                {{-- costo // costo_plan--}}
                <div class="col-sm-6 col-lg-4">
                    <div>
                        <label for="costo_plan" class="col-form-label">Costo del plan </label>
                    </div>

                    <div>
                        <input type="number" class="form-control" id="costo_plan" wire:model="form.costo_plan"
                            placeholder="0">
                        <small class="text-danger">
                            @error('form.costo_plan')
                            {{ $message }}
                            @enderror
                        </small>
                    </div>
                </div>


                {{-- Socio
                <div class="col-sm-6 col-lg-4">
                    <div>
                        <label for="fullName" class="col-form-label">Socio</label>
                    </div>

                    <div>
                        <select class="form-select" name="socio" id="socio" wire:model="form.socio">
                            <option value=""></option>
                            @foreach ($socios as $socio)
                            <option value="{{ $socio->persona->uuid }}">
                                {{ $socio->persona->nombres }}
                            </option>
                            @endforeach
                        </select>
                        <small class="text-danger">
                            @error('form.socio')
                            {{ $message }}
                            @enderror
                        </small>
                    </div>
                </div> --}}
                {{-- Vendedor // vendedor_uuid--}}
                <div class="col-sm-6 col-lg-4">
                    <div>
                        <label for="fullName" class="col-form-label">Vendedor</label>
                    </div>

                    <div>
                        <select class="form-select" name="vendedor_uuid" id="vendedor_uuid"
                            wire:model="form.vendedor_uuid">
                            <option value="">Seleccione una opcion</option>
                            @foreach ($vendedores as $vendedor)
                            <option value="{{ $vendedor->persona->uuid }}">
                                {{ $vendedor->persona->nombres }}
                            </option>
                            @endforeach
                        </select>
                        <small class="text-danger">
                            @error('form.vendedor_uuid')
                            {{ $message }}
                            @enderror
                        </small>
                    </div>
                </div>

                {{-- Estatus // status--}}
                <div class="col-sm-6 col-lg-4">
                    <div>
                        <label for="status" class="col-form-label">Status</label>
                    </div>

                    <div>
                        <select class="form-select" id="status" name="status">

                            <option value="activo">Activa</option>
                            <option value="inactivo">Inactiva</option>
                            <option value="pausada">Pausada</option>
                            <option value="pausada_por_pago">Pausada por pago</option>
                        </select>
                        <small class="text-danger">
                            @error('status')
                            {{ $message }}
                            @enderror
                        </small>
                    </div>
                </div>

                <div class="d-flex justify-content-end gap-2 mt-4">
                    <!-- Button -->
                    @if ($uuid)
                    <button type="button" wire:click="resetForm" class="btn btn-danger">Reiniciar</button>
                    @else
                    <button type="button" wire:click="cleanForm" class="btn btn-danger">Limpiar</button>
                    @endif
                    <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                </div>
            </div>

    </div>

    </form>

</div>

{{-- <select id="proveedor">
    <!-- Opciones de proveedores aquí -->
    <option value="">Seleccione</option>
    <option value="1">Proveedor 1</option>
    <option value="2">Proveedor 2</option>
</select>

<select id="plan">
    <!-- Opciones de planes aquí -->
</select> --}}

</div>
{{-- <script>
    var url = "{{ route('planes.porProveedor') }}";

    document.getElementById('proveedor').addEventListener('change', function() {
    var proveedor = this.value;

    // console.log(url +'/'+ proveedor);
    try {
        fetch(url +'/'+ proveedor)
            .then(function(response) {

                if (!response.ok) {
                    throw new Error('Error en la respuesta del servidor');
                }
                return response.json();

            })
            .then(function(data) {
                console.log(data);
                var select = document.getElementById('plan');
                var costo = document.getElementById('costo_plan');
                select.innerHTML = '';

                var option = document.createElement('option');
                var option = document.createElement('option');
                option.value = "";
                option.text = "Seleccione una opcion";
                select.add(option);
                data.forEach(function(plan) {
                    var option = document.createElement('option');
                    // agregar info de data
                    option.setAttribute('data-precio', plan.precio);
                    option.value = plan.id;
                    option.text = plan.nombre;
                    select.add(option);
                });
            })
            .catch(function(error) {
                console.error('Error:', error);
            });
    } catch (error) {
        console.error('Error:', error);
    }
    document.getElementById('plan').addEventListener('change', function() {
        let select_plan = document.getElementById('plan');
        // console.log(plan_cambiado);
        let plan_Seleccionado = select_plan.options[select_plan.selectedIndex];
        let precio_plan_seleccionado = plan_Seleccionado.getAttribute('data-precio');
        var costo = document.getElementById('costo_plan');
        costo.value = precio_plan_seleccionado;



    });
});
 --}}




</script>