<div>
    @section('title', $pageTitle)

    <div class="col">
        <form wire:submit="save">
            <!-- Card -->
            <div class="card border-0 scroll-mt-3" id="basicInformationSection">
                <div class="card-header">
                    <h2 class="h3 mb-0 text-center">{{ $pageTitle }}</h2>
                </div>

                <div class="card-body row mb-4">

                    <fieldset class="row mb-6">
                        <legend>Información General</legend>
                        <div class="col-sm-6 col-lg-4">
                            <div>
                                <label for="fullName" class="col-form-label">Nombre</label>
                            </div>
                            <div>
                                <input class="form-control" id="fullName" wire:model="form.nombre">
                                <small class="text-danger">
                                    @error('form.nombre')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div> <!-- / .row -->
                        <div class="col-sm-6 col-lg-4">
                            <div>
                                <label for="fullName" class="col-form-label">IP</label>
                            </div>

                            <div>
                                <input class="form-control" id="fullName" wire:model="form.ip">
                                <small class="text-danger">
                                    @error('form.ip')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div> <!-- / .row -->
                        <div class="col-sm-6 col-lg-4">
                            <div>
                                <label for="fullName" class="col-form-label">Serial</label>
                            </div>

                            <div>
                                <input class="form-control" id="fullName" wire:model="form.serial" />
                                <small class="text-danger">
                                    @error('form.serial')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div> <!-- / .row -->
                        <div class="col-sm-6 col-lg-4">
                            <div>
                                <label for="fullName" class="col-form-label">Identify</label>
                            </div>

                            <div>
                                <input class="form-control" id="fullName" wire:model="form.identify" />
                                <small class="text-danger">
                                    @error('form.identify')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div> <!-- / .row -->
                        <div class="col-sm-6 col-lg-4">
                            <div>
                                <label for="modelo" class="col-form-label">Modelo</label>
                            </div>

                            <div>
                                <select class="form-select" wire:model="form.modelo" id="modelo">
                                    <option value=""></option>
                                    @foreach ($modelos_mikrotiks as $modelo)
                                    <option value="{{ $modelo->uuid }}">{{ $modelo->nombre }}</option>
                                    @endforeach
                                </select>
                                <small class="text-danger">
                                    @error('form.modelo')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div> <!-- / .row -->
                        <div class="col-sm-6 col-lg-4">
                            <div>
                                <label for="fullName" class="col-form-label">VPN User</label>
                            </div>

                            <div>
                                <input class="form-control" id="fullName" wire:model="form.vpnUser">
                                <small class="text-danger">
                                    @error('form.vpnUser')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div> <!-- / .row -->
                        <div class="col-sm-6 col-lg-4">
                            <div>
                                <label for="fullName" class="col-form-label">VPN Password</label>
                            </div>

                            <div>
                                <input class="form-control" id="fullName" wire:model="form.vpnPassword">
                                <small class="text-danger">
                                    @error('form.vpnPassword')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div> <!-- / .row -->
                        <div class="col-sm-6 col-lg-4">
                            <div>
                                <label for="fullName" class="col-form-label">VPN Server</label>
                            </div>

                            <div>
                                <input class="form-control" id="fullName" wire:model="form.vpnServer">
                                <small class="text-danger">
                                    @error('form.vpnServer')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div> <!-- / .row -->
                        <div class="col-sm-6 col-lg-4">
                            <div>
                                <label for="fullName" class="col-form-label">ETH Corte 1</label>
                            </div>

                            <div>
                                <input class="form-control" id="fullName" wire:model="form.ethrCorte1">
                                <small class="text-danger">
                                    @error('form.ethrCorte1')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div> <!-- / .row -->
                        <div class="col-sm-6 col-lg-4">
                            <div>
                                <label for="fullName" class="col-form-label">ETH Corte 2</label>
                            </div>

                            <div>
                                <input class="form-control" id="fullName" wire:model="form.ethrCorte2">
                                <small class="text-danger">
                                    @error('form.ethrCorte2')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div> <!-- / .row -->
                        <div class="col-sm-6 col-lg-4">
                            <div>
                                <label for="fullName" class="col-form-label">Usuario</label>
                            </div>

                            <div>
                                <input class="form-control" id="fullName" wire:model="form.usuario">
                                <small class="text-danger">
                                    @error('form.usuario')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div> <!-- / .row -->
                        <div class="col-sm-6 col-lg-4">
                            <div>
                                <label for="fullName" class="col-form-label">Clave</label>
                            </div>

                            <div>
                                <input class="form-control" id="fullName" wire:model="form.clave">
                                <small class="text-danger">
                                    @error('form.clave')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div> <!-- / .row -->
                    </fieldset>
                    <fieldset class="row">
                        <legend class="mb-2">Protocolos</legend>
                        @foreach ($protocolos as $protocolo)
                        <div class="col-4 col-lg-3">
                            <label for="">{{ $protocolo->protocolo }}</label>
                            <input class="form-control m-2" wire:model="form.protocolos.{{ $protocolo->protocolo }}">

                            <small class="text-danger">
                                @error('form.protocolos.{{ $protocolo->protocolo }}')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                        @endforeach
                    </fieldset>
                    <div class="d-flex justify-content-end gap-2">
                        <!-- Button -->
                        @if ($uuid)
                        <button type="button" wire:click="resetForm" class="btn btn-danger">Reiniciar</button>
                        @else
                        <button type="button" wire:click="cleanForm" class="btn btn-danger">Limpiar</button>
                        @endif
                        <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                    </div>
                </div>

            </div>

        </form>

    </div>

</div>