<div>
    @section('title', $title)


    <style>
        td {
            font-size: 14px;
            vertical-align: middle;
        }

        .table {
            margin-bottom: 0;
        }

        .table * {
            border-bottom-width: 2px;
        }

        .table th,
        .table td {
            padding: 12px 15px;
        }

        .table thead th {
            padding: 12px 15px;
            background-color: rgba(0, 0, 0, 0.05);
            font-weight: 600;
            white-space: nowrap;
        }

        .table-responsive {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        .card {
            width: 100%;
        }

        /* Asegurar que los botones de acción estén en línea */
        td .d-flex {
            flex-wrap: nowrap;
        }

        td .d-flex .btn {
            white-space: nowrap;
        }

        /* Gap entre botones si no está soportado */
        .gap-1 > * + * {
            margin-left: 0.25rem;
        }
    </style>
    <div class="container-fluid pt-2">

        <header class="mb-4">
            <h1 class="text-center h1">{{ $title }} </h1>
        </header>


        {{-- Card 1 --}}
        <div class="card shadow p-0 mb-3">

                <div class="card-header pb-2">
                    <div class="row">
                        <p class="col">
                            Cantidades en Metodos de pago
                        </p>

                        <div class="col  d-flex flex-column align-items-end">
                            {{-- <input class="form-control list-search mw-300px d-none " wire:model.live="search"
                                type="search" placeholder="Buscar"> --}}
                            <button type="button" class="btn btn-danger btn-sm" onclick="confirmarReset()">
                                <i class="fa-solid fa-rotate-left me-1"></i>
                                Reset
                            </button>
                        </div>

                    </div>
                </div>

                <div class="card-body p-3">
                    <div class="table-responsive">
                        <table class="table table-bordered w-100">
                            <thead>
                                <tr>
                                    {{-- <th scope="col" class="text-left  ">#</th> --}}
                                    <th scope="col" class="text-left">Metodo</th>
                                    <th scope="col" class="text-center">Remotas activas /<br>No activas</th>
                                    <th scope="col" class="text-right">Coste</th>
                                    <th scope="col" class="text-right">Cantidad<br>Recargada</th>
                                    <th scope="col" class="text-right">Tope</th>
                                    <th scope="col" class="text-center">Acción</th>
                                </tr>
                            </thead>
                        <tbody>
                            @forelse ($payment_methods as $pm)


                            <tr>
                                <td class="text-left">{{ $pm->name }}</td>
                                <td class="text-center">{{ $pm->remotas_activas_count }} / {{ $pm->remotas_no_activas_count }}</td>
                                <td class="text-right">$ @money($pm->total_costo)</td>
                                <td class="text-right">$ @money($pm->cantidad_registrada)</td>
                                <td class="text-right">$ @money($pm->tope)</td>
                                <td class="text-center">
                                    <div class="d-flex justify-content-center align-items-center gap-1">
                                        <button type="button" class="btn btn-xs btn-info p-3 pt-1 pb-1"
                                            data-bs-toggle="modal"
                                            data-bs-target="#ver_remotas_pm_{{  $pm->id }}" title="Ver remotas">
                                            <i class="fa-solid fa-table-list"></i>
                                        </button>
                                    </div>

                                    {{-- Modal Ver Remotas PM --}}
                                    <div class="modal modal-md fade" id="ver_remotas_pm_{{  $pm->id }}"
                                        tabindex="-1" aria-labelledby="label_ver_remotas_pm_{{ $pm->id }}" aria-hidden="true">
                                        <div class="modal-dialog modal-lg">
                                            <div class="modal-content">
                                                <div class="modal-header bg-info">
                                                    <h1 class="modal-title fs-5" id="label_ver_remotas_pm_{{ $pm->id }}">
                                                        {{ $pm->name }}
                                                    </h1>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    @php
                                                        $remotasListado = \App\Models\Remota::select('id','cliente_id','equipo','status')
                                                            ->where('metodo_de_pago_id', $pm->id)
                                                            ->orderBy('status', 'asc')
                                                            ->get();
                                                    @endphp
                                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                                        <small class="text-muted">Mostrando <span id="count_remotas_pm_{{ $pm->id }}">{{ $remotasListado->count() }}</span> remotas</small>
                                                        <input type="search" class="form-control form-control-sm mw-300px" placeholder="Buscar" id="search_remotas_pm_{{ $pm->id }}" oninput="filtrarRemotasPM({{ $pm->id }})">
                                                    </div>
                                                    <table id="tabla_remotas_pm_{{ $pm->id }}" class="table table-bordered  mt-40">
                                                        <thead>
                                                            <tr>
                                                                <th scope="col" class="text-left">#</th>
                                                                <th scope="col" class="text-left">Remota</th>
                                                                <th scope="col" class="text-left">Cliente</th>
                                                                <th scope="col" class="text-left">Estatus</th>
                                                                <th scope="col" class="text-left">Acción</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @forelse ($remotasListado as $item)
                                                            <tr>
                                                                <td class="text-left">{{ $item->id }}</td>
                                                                <td class="text-left">{{ $item->equipo }}</td>
                                                                <td class="text-left">{{ $item->cliente->getClientName() }}</td>
                                                                <td class="text-left">
                                                                    <span class="badge bg-{{ $item->estadoBadge }}">{{ $item->status }}</span>
                                                                </td>
                                                                <td class="text-left">
                                                                    <a target="_blank" href="{{ route('remotas.show', $item->id) }}"
                                                                       class="btn btn-xs btn-info p-3 pt-1 pb-1 me-1" title="Ver detalle">
                                                                        <i class="fa-solid fa-eye"></i>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                            @empty
                                                            <tr>
                                                                <td colspan="5" class="text-center">No existen remotas asociadas a este método.</td>
                                                            </tr>
                                                            @endforelse
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <td colspan="6" class="text-center">
                                Error: al cargar metodos de pago </td>
                            @endforelse

                        </tbody>
                        </table>
                    </div>
                </div>
                {{-- <div class="card-footer">
                    <div class="d-flex justify-content-center">
                        {{ $remotas_por_pagar->links() }}
            </div>
        </div> --}}
        </div>

        {{-- Card 2 --}}
        <div class="card shadow p-0 mb-3">

        <div class="card-header pb-2">
            <div class="row">
                <p class="col">
                    {{ $title }}
                </p>

                <div class="col  d-flex flex-column align-items-end">
                    {{-- <input class="form-control list-search mw-300px d-none " wire:model.live="search"
                                type="search" placeholder="Buscar"> --}}

                </div>

            </div>
        </div>

        <div class="card-body p-3">
            <div class="table-responsive">
                <table class="table table-bordered datatable2 w-100">
                    <thead>
                        <tr>
                            {{-- <th scope="col" class="text-left  ">#</th> --}}
                            <th scope="col" class="text-left">Correo</th>
                            <th scope="col" class="text-center">Remotas activas</th>
                            <th scope="col" class="text-left">Metodo de pago</th>
                            <th scope="col" class="text-center">Corte</th>
                            <th scope="col" class="text-center">Ultima Recarga</th>
                            <th scope="col" class="text-right">Costo</th>
                            <th scope="col" class="text-right">Tope</th>
                            <th scope="col" class="text-center">Acción</th>
                        </tr>
                    </thead>
                <tbody>
                    @forelse ($filas as $remota)



                    <tr class="{{ $remota->total_costo_activas == 0? 'text-secondary':'' }}">
                        {{--= id --}}
                        <td class="text-left">{{ $remota->correo_cuenta }}</td>
                        <td class="text-center">

                            {{ $remota->activas }}
                            @if ($remota->no_activas != 0)

                            / <strong class="text-secondary">
                                {{$remota->no_activas }}
                                <!-- {{$remota->total }} -->
                            </strong>
                            @endif


                        </td>
                        <td class="text-left">{{ $remota->metodo_de_pago }}</td>
                        <td class="text-center">{{ $remota->dia_fecha_cuenta }}</td>
                        <td class="text-center">{{ $remota->fecha_de_recarga ?? '' }}</td>
                        <td class="text-right">$ @money($remota->total_costo_activas)</td>
                        <td class="text-right">$ @money($remota->metodo_de_pago_tope)</td>


                        {{--= Acciones --}}
                        <td scope="col" class="text-center">
                            <div class="d-flex justify-content-center align-items-center gap-1">
                                <button type="button" class="btn btn-xs btn-info p-3 pt-1 pb-1"
                                    data-bs-toggle="modal"
                                    data-bs-target="#ver_remotas_{{  $remota->correo_cuenta }}" title="Ver remotas">
                                    <i class="fa-solid fa-table-list"></i>
                                </button>
                            <div class="modal modal-md fade" id="ver_remotas_{{  $remota->correo_cuenta }}"
                                tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-lg">
                                    <div class="modal-content">
                                        <div class="modal-header bg-info">

                                            <h1 class="modal-title fs-5" id="exampleModalLabel">
                                                {{ $remota->correo_cuenta }}
                                            </h1>


                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            @php
                                                $remotas = $remota->registros;
                                                $array = explode(',', $remota->registros);

                                                $remotas =
                                                App\Models\Remota::select('id','cliente_id','equipo','status')
                                                ->whereIn('id',$array)
                                                ->orderBy('status', 'asc')
                                                ->get();
                                            @endphp
                                            <div class="d-flex justify-content-between align-items-center mb-2">
                                                <small class="text-muted">Mostrando <span id="count_remotas_{{ $remota->correo_cuenta }}">{{ $remotas->count() }}</span> remotas</small>
                                                <input type="search" class="form-control form-control-sm mw-300px" placeholder="Buscar" id="search_remotas_{{ $remota->correo_cuenta }}" oninput="filtrarRemotasCorreo('{{ $remota->correo_cuenta }}')">
                                            </div>
                                            <table id="tabla_remotas_{{ $remota->correo_cuenta }}" class="table table-bordered  mt-40">
                                                <thead>
                                                    <tr>
                                                        <th scope="col" class="text-left">#</th>
                                                        <th scope="col" class="text-left">Remota</th>
                                                        <th scope="col" class="text-left">Cliente</th>
                                                        <th scope="col" class="text-left">Estatus</th>
                                                        <th scope="col" class="text-left">Acción</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse ($remotas as $item)
                                                    <tr>
                                                        <td class="text-left">{{ $item->id }}</td>
                                                        <td class="text-left">{{ $item->equipo }}</td>
                                                        <td class="text-left">{{ $item->cliente->getClientName()
                                                                    }}
                                                        <td class="text-left">
                                                            <span class="badge bg-{{ $item->estadoBadge }}">{{
                                                                        $item->status }}</span>


                                                        </td>


                                                        <td class="text-left">
                                                            <a target="_blank"
                                                                href="{{ route('remotas.show', $item->id) }}"
                                                                class="btn btn-xs btn-info p-3 pt-1 pb-1 me-1"
                                                                title="Ver detalle">
                                                                <i class="fa-solid fa-eye"></i>
                                                            </a>
                                                        </td>

                                                    </tr>

                                                    @empty

                                                    @endforelse

                                                </tbody>
                                            </table>


                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-bs-dismiss="modal">Cerrar</button>
                                            {{-- <button type="button"
                                                        onclick="emitirUpdate(event,'{{  $remota->correo_cuenta }}')"
                                            title="Editar " class="btn btn-info ">
                                            Actualizar
                                            </button> --}}

                                        </div>
                                    </div>
                                </div>
                            </div>

                                {{-- Acciones rapidas --}}
                                <button type="button" class="btn btn-xs btn-warning p-3 pt-1 pb-1"
                                    data-bs-toggle="modal"
                                    data-bs-target="#acciones_rapidas_{{ $remota->correo_cuenta }}"
                                    title="Acciones rápidas">
                                    <i class="fa-solid fa-money-bill-transfer"></i>
                                </button>
                            </div>

                            <!-- Modal acciones rapidas  -->
                            <div class="modal modal-md fade" id="acciones_rapidas_{{ $remota->correo_cuenta }}"
                                tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header bg-warning">

                                            <h1 class="modal-title fs-5" id="exampleModalLabel">
                                                {{ $remota->correo_cuenta }}
                                            </h1>


                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">

                                            {{--=================================================== Recargar
                                                    antena --}}
                                            <div class="row">
                                                <p>Recargar Antena</p>
                                            </div>
                                            <div class="row">
                                                {{-- fecha_recarga --}}
                                                <div class="col col-md-8 ">


                                                    <label for="fecha_recarga_{{ $remota->correo_cuenta }}"
                                                        class="col-form-label">Fecha de
                                                        recarga</label>


                                                    <input type="date" class="form-control"
                                                        id="fecha_recarga_{{ $remota->correo_cuenta }}"
                                                        data-flatpickr name="fecha_recarga"
                                                        placeholder="Seleccione una fecha"
                                                        value="{{now()->format('Y-m-d')  }}" required>
                                                    <small class="text-danger">
                                                        @error('fecha_recarga')
                                                        {{ $message }}
                                                        @enderror
                                                    </small>
                                                    <small class="text-danger">
                                                        @error('fecha_recarga')
                                                        {{ $message }}
                                                        @enderror
                                                    </small>
                                                </div>
                                                <div
                                                    class="col col-md-4 d-flex align-items-end justify-content-end">

                                                    <button type="button"
                                                        data-correo="{{ $remota->correo_cuenta }}"
                                                        data-metodo="{{ $remota->metodo_de_pago_id }}"
                                                        data-costo="{{ $remota->total_costo_activas }}"
                                                        onclick="emitirRecargar(event, this)"
                                                        title="Recargar"
                                                        class="btn btn-success ">Recargar</button>
                                                </div>
                                            </div>


                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-bs-dismiss="modal">Cerrar</button>

                                        </div>
                                    </div>
                                </div>
                            </div>



                        </td>


                    </tr>
                    @empty
                    <td colspan="8" class="text-center">
                        Error: al cargar las remotas</td>
                    @endforelse

                </tbody>
                </table>
            </div>
        </div>
        {{-- <div class="card-footer">
                    <div class="d-flex justify-content-center">
                        {{ $remotas_por_pagar->links() }}
    </div>
</div> --}}
        </div>

        {{-- <div id="calendar"></div> <!-- Este es el contenedor donde FullCalendar se renderiza --> --}}

    </div>
</div>
<script>
    $(document).ready(function() {
        var dataTableConfig2 = {
            "order": [
                [3, "asc"]
            ],
            // "ordering": false, // Desactiva el ordenamiento por defecto

            "pageLength": 50,
            "language": {
                "sProcessing": "Procesando...",
                "sLengthMenu": "Mostrar _MENU_ registros",
                "sZeroRecords": "No se encontraron resultados",
                "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
                "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
                "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
                "sSearch": "Buscar:",
                "sEmptyTable": "No hay datos disponibles en la tabla",
                "sLoadingRecords": "Cargando...",
                "oPaginate": {
                    "sFirst": "Primero",
                    "sLast": "Último",
                    "sNext": "Siguiente",
                    "sPrevious": "Anterior"
                },
                "oAria": {
                    "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                    "sSortDescending": ": Activar para ordenar la columna de manera descendente"
                }
            }
        };

        // Inicializar DataTable con la configuración guardada en la variable
        $('.datatable2').DataTable(dataTableConfig2);
    });
</script>
<script>
    function cerrarModal(id) {
        let modal = document.getElementById('acciones_rapidas_' + id)
        let backdrop = document.querySelector('.modal-backdrop')

        setTimeout(function() {
            if (modal) {
                modal.parentNode.removeChild(modal)
            }
            if (backdrop) {
                backdrop.parentNode.removeChild(backdrop)
            }
            document.body.style.overflow = ''
            document.body.style.paddingRight = ''
        }, 1400)

    }

    function emitirRecargar(e, button) {
        e.preventDefault();
        let correo_cuenta = button.getAttribute('data-correo');
        let metodos_de_pago_id = button.getAttribute('data-metodo');
        let total_costo_activas = button.getAttribute('data-costo');
        let fecha_recarga = document.getElementById('fecha_recarga_' + correo_cuenta)
        console.log(correo_cuenta, fecha_recarga.value)

        cerrarModal(correo_cuenta);
        Livewire.dispatch('listenersRecargar', {
            correo_cuenta: correo_cuenta,
            fecha_recarga: (fecha_recarga.value),
            metodos_de_pago_id: metodos_de_pago_id,
            total_costo_activas: total_costo_activas
        })
    }

    function confirmarReset() {
        if (confirm('¿Estás seguro de resetear la cantidad registrada?')) {
            emitirResetear();
        }
    }

    function emitirResetear() {
        // alert('Función de resetear ejecutada');
        // Aquí puedes agregar la lógica para emitir el evento a Livewire
        // Livewire.dispatch('listenersResetear');
        Livewire.dispatch('listenersResetear');
    }

    function filtrarRemotasPM(pmId) {
        const input = document.getElementById('search_remotas_pm_' + pmId);
        const table = document.getElementById('tabla_remotas_pm_' + pmId);
        if (!table) return;

        const term = (input?.value || '').toLowerCase();
        let visible = 0;

        table.querySelectorAll('tbody tr').forEach(function(row) {
            const txt = row.textContent.toLowerCase();
            const show = txt.indexOf(term) !== -1;
            row.style.display = show ? '' : 'none';
            if (show) visible++;
        });

        const countEl = document.getElementById('count_remotas_pm_' + pmId);
        if (countEl) countEl.textContent = visible;
    }

    function filtrarRemotasCorreo(correo) {
        const input = document.getElementById('search_remotas_' + correo);
        const table = document.getElementById('tabla_remotas_' + correo);
        if (!table) return;

        const term = (input?.value || '').toLowerCase();
        let visible = 0;

        table.querySelectorAll('tbody tr').forEach(function(row) {
            const txt = row.textContent.toLowerCase();
            const show = txt.indexOf(term) !== -1;
            row.style.display = show ? '' : 'none';
            if (show) visible++;
        });

        const countEl = document.getElementById('count_remotas_' + correo);
        if (countEl) countEl.textContent = visible;
    }
</script>
