<div>
    @section('title', $title)

    <style>
        td {
            font-size: 14px;
        }

        .table * {
            border-bottom-width: 2px;
        }

        .table th,
        .table td {
            padding: 2px 5px 2px 5px;
        }

        .table thead th {
            padding: 0px 0px 10px 0px;
        }

        .col-75 {
            width: 75%;
        }

        .col-60 {
            width: 60%;
        }

        .col-50 {
            width: 50%;
        }

        .col-40 {
            width: 40%;
        }

        .col-25 {
            width: 25%;
        }

        .col-15 {
            width: 15%;
        }

        .col-10 {
            width: 10%;
        }
    </style>

    <div class="pt-2 d-flex flex-column">

        <header class="mb-4">
            <h1 class="text-center h1">{{ $title }} </h1>
        </header>

        <div>
            {{-- Modal agregar --}}
            <x-modal-alpine name="new_payment_method" title="Agregar nuevo método de pago">
                <x-slot:body>
                    <section class="bg-white py-8 lg:py-16 px-4 mx-auto max-w-screen-md">
                        <h2 class="mb-4 text-4xl font-extrabold text-center text-gray-900">
                            Nuevo método de pago
                        </h2>
                        <p class="mb-8 lg:mb-16 text-center text-gray-500 sm:text-xl">
                            Crear nuevos métodos de pago para clientes o para uso de la empresa.
                        </p>
                        <form wire:submit.prevent="save" class="space-y-4">
                            @csrf
                            <!-- Token CSRF para la protección -->
                            <!-- Campo: Nombre del método de pago -->
                            <div class="mb-3">
                                <label for="name" class="form-label">Nombre del método de pago</label>
                                <input wire:model="name" type="text" id="name" class="form-control"
                                    placeholder="Nombre del método de pago" required>
                            </div>

                            <!-- Campo: Descripción del método de pago -->
                            <div class="mb-3">
                                <label for="description" class="form-label">Descripción</label>
                                <textarea wire:model="description" id="description" rows="4" class="form-control"
                                    placeholder="Descripción del método de pago" required></textarea>
                            </div>

                            <!-- Campo: Tipo (Cliente o Empresa) -->
                            <div x-data="{ tipo: '' }">
                                <!-- Inicializa la variable tipo aquí -->
                                <!-- Campo: Tipo (Cliente o Empresa) -->
                                <div class="mb-3">
                                    <label for="tipo_metodo_pago" class="form-label">Tipo de pago</label>
                                    <select x-model="tipo" id="tipo_metodo_pago" class="form-select" required
                                        @change="$wire.set('tipo_metodo_pago', tipo)">
                                        <option value="" selected>Seleccionar tipo</option>
                                        <option value="cliente">Cliente</option>
                                        <option value="empresa">Empresa</option>
                                    </select>
                                </div>

                                <!-- Campo: Tope (visible solo si se selecciona Empresa) -->
                                <div class="mb-3" x-show="tipo === 'empresa'" x-transition>
                                    <label for="tope" class="form-label">Tope</label>
                                    <input wire:model="tope" type="number" id="tope" class="form-control"
                                        placeholder="Ingrese el tope" step="0.01" min="0">
                                </div>
                            </div>


                            <!-- Botón de enviar -->
                            <button type="submit" class="btn btn-primary w-100">Agregar método de pago</button>
                        </form>
                    </section>
                    </x-slot>
            </x-modal-alpine>




            <!-- Button to Open Modal -->

        </div>
        <div class="row mt-3">
            <div class="card shadow p-0">

                <div class="card-header pb-2">
                    <div class="row">
                        <p class="col">
                            {{ $title }}
                        </p>


                        <div class="col d-flex flex-column align-items-end">


                            <!-- Botón para abrir el modal -->
                            <button class="btn btn-sm btn-primary" x-data
                                @click="$dispatch('open-modal', {name: 'new_payment_method'})">
                                <i class="fas fa-plus"></i>
                                Agregar nuevo método de pago
                            </button>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <table class="table table-bordered table-striped datatable mt-40">
                        <thead>
                            <tr>
                                <th scope="col" class="text-center">#</th>
                                <th scope="col" class="text-center">Nombre</th>
                                <th scope="col" class="text-center">Descripcion</th>
                                <th scope="col" class="text-center">Estatus</th>
                                <th scope="col" class="text-center">Tipo</th>
                                <th scope="col" class="text-center">Tope</th>
                                <th scope="col" class="text-center">Acción</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($filas as $pm)
                            <tr>
                                <td class="text-center">{{ $pm->id }}</td>
                                <td class="text-left truncate">@truncate($pm->name) </td>
                                <td class="text-left truncate">@truncate($pm->description,40)</td>
                                <td class="text-center">
                                    @if ($pm->is_active == 1)
                                    <span class="badge bg-success">Activo</span>
                                    @else
                                    <span class="badge bg-danger">Inactivo</span>
                                    @endif
                                </td>
                                <td class="text-center">{{ $pm->tipo_metodo_pago }}</td>
                                <td class="text-center">$ @money($pm->tope)</td>
                                <!-- Botón de Editar -->
                                <td class="text-center">



                                    <!--======================================= Editar -->
                                    <button type="button" class="btn btn-xs btn-warning p-3 pt-1 pb-1 me-1"
                                        data-bs-toggle="modal" data-bs-target="#editar_{{  $pm->id }}" title="Editar">

                                        <i class="fa-solid fa-pen-to-square"></i>

                                    </button>

                                    <!----=================================================== Modal Editar   -->
                                    <div class="modal modal-md fade" id="editar_{{  $pm->id }}" tabindex="-1"
                                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header bg-warning">

                                                    <h1 class="modal-title fs-5" id="exampleModalLabel">
                                                        {{ $pm->name }} - {{ $pm->tipo_metodo_pago }}
                                                    </h1>


                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">

                                                    {{--=================================================== editar
                                                    antena --}}

                                                    <div class="row">
                                                        {{-- Nombre --}}
                                                        <div class="col col-md-5 ">
                                                            <label for="name_{{  $pm->id }}"
                                                                class="col-form-label text-left">Nombre</label>
                                                            <input type="text" class="form-control"
                                                                id="name_{{  $pm->id }}" name="name"
                                                                value="{{ $pm->name }}" required>
                                                            <small class="text-danger">
                                                                @error('name')
                                                                {{ $message }}
                                                                @enderror
                                                            </small>
                                                        </div>
                                                        {{-- Descripción --}}
                                                        <div class="col col-md-7 ">
                                                            <label for="description_{{  $pm->id }}"
                                                                class="col-form-label text-left">Descripcion</label>
                                                            <input type="text" class="form-control"
                                                                id="description_{{  $pm->id }}" name="description"
                                                                value="{{ $pm->description }}" required>
                                                            <small class="text-danger">
                                                                @error('description')
                                                                {{ $message }}
                                                                @enderror
                                                            </small>
                                                        </div>
                                                        {{-- Estatus --}}
                                                        <div class="col col-md-5 ">
                                                            <label for="is_active_{{  $pm->id }}"
                                                                class="col-form-label text-left">Estatus</label>
                                                            <select class="form-select" id="is_active_{{  $pm->id }}"
                                                                name="is_active" required>
                                                                <option value="1" {{ $pm->is_active == 1 ? 'selected' :
                                                                    '' }}>
                                                                    Activo</option>
                                                                <option value="0" {{ $pm->is_active == 0 ? 'selected' :
                                                                    '' }}>
                                                                    Inactivo</option>
                                                            </select>
                                                            <small class="text-danger">
                                                                @error('is_active')
                                                                {{ $message }}
                                                                @enderror
                                                            </small>
                                                        </div>

                                                        {{-- Tipo de metood de pago --}}
                                                        <div class="col col-md-7 ">
                                                            <label for="tipo_metodo_pago_{{  $pm->id }}"
                                                                class="col-form-label text-left">Tipo de pago</label>
                                                            <select class="form-select"
                                                                id="tipo_metodo_pago_{{  $pm->id }}"
                                                                name="tipo_metodo_pago" required>
                                                                <option value="cliente" {{ $pm->tipo_metodo_pago ==
                                                                    'cliente' ? 'selected' : '' }}>
                                                                    Cliente</option>
                                                                <option value="empresa" {{ $pm->tipo_metodo_pago ==
                                                                    'empresa' ? 'selected' : '' }}>
                                                                    Empresa</option>
                                                            </select>
                                                            <small class="text-danger">
                                                                @error('tipo_metodo_pago')
                                                                {{ $message }}
                                                                @enderror
                                                            </small>
                                                        </div>

                                                        {{-- Tope --}}
                                                        <div class="col col-md-5 ">
                                                            <label for="tope_{{  $pm->id }}"
                                                                class="col-form-label text-left">Tope</label>
                                                            <input type="number" class="form-control"
                                                                id="tope_{{  $pm->id }}" name="tope" min="0"
                                                                value="{{ $pm->tope ??0 }}" required>
                                                            <small class="text-danger">
                                                                @error('tope')
                                                                {{ $message }}
                                                                @enderror
                                                            </small>
                                                        </div>



                                                    </div>
                                                    <hr>


                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Cerrar</button>
                                                    <button type="button" onclick="emitirUpdate(event,'{{  $pm->id }}')"
                                                        title="Editar " class="btn btn-info ">Actualizar</button>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!--============================ Botón de Eliminar -->
                                    <button class="btn btn-xs btn-danger p-3 pt-1 pb-1 me-1" onclick="
                                                emitirEliminar(event,{{ $pm->id }})" title="Eliminar">
                                        <i class="fas fa-trash"></i>
                                    </button>

                                </td>


                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center">
                                    Error: al cargar los métodos de pago
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>


    </div>


</div>
<script>
    function emitirEliminar(e, id){
        e.preventDefault();

        Swal.fire({
            title: '¿Estás seguro?',
            text: "¡No podrás revertir esto!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Sí, bórralo!',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                Livewire.dispatch('deletePaymentMethod', {
                    payment_mehtod: id,
                });
                }
        })




    }

    function cerrarModal(id) {
        let modal = document.getElementById('editar_' + id)
        let backdrop = document.querySelector('.modal-backdrop')

        setTimeout(function() {
            if (modal) {
                modal.parentNode.removeChild(modal)
            }
            if (backdrop) {
                backdrop.parentNode.removeChild(backdrop)
            }
            document.body.style.overflow = ''
            document.body.style.paddingRight = ''
        }, 1400)

    }

    function emitirUpdate(e, pm_id) {
        e.preventDefault();
        let name = document.getElementById('name_' + pm_id)
        let description = document.getElementById('description_' + pm_id)
        let is_active = document.getElementById('is_active_' + pm_id)
        let tipo_metodo_pago = document.getElementById('tipo_metodo_pago_' + pm_id)
        let tope = document.getElementById('tope_' + pm_id)

        cerrarModal(pm_id);
        Livewire.dispatch('updatePaymentMethod', {
            payment_method_id: pm_id,
            name: name.value,
            description: description.value,
            is_active: is_active.value,
            tipo_metodo_pago: tipo_metodo_pago.value,
            tope: tope.value
        })
    }
</script>