<x-app-layout>

    @section('title', 'Dashboard')

    <div class="row">
        <hr>
        <h4>Informacion de mes actual</h4>
        <div class="row">

            {{-- Ingresos --}}
            <div class="col-md-6">

                <!-- Card -->
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col d-flex justify-content-between">

                                <div>
                                    <!-- Title -->
                                    <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                        <span class="legend-circle-sm bg-success"></span>
                                        Ingreso
                                    </h5>

                                    <!-- Subtitle -->
                                    <h2 class="mb-0">
                                        $ @money($datos['saldo_cobrado'])
                                    </h2>

                                    <!-- Comment -->
                                    <p class="fs-6 text-muted mb-0">
                                        <a href="{{ route('dashboard.ingreso_mensual_actual') }}">Ver detalles</a>
                                    </p>
                                </div>

                                <span class="text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="32" width="32">
                                        <defs>
                                            <style>
                                                .a {
                                                    fill: none;
                                                    stroke: currentColor;
                                                    stroke-linecap: round;
                                                    stroke-linejoin: round;
                                                    stroke-width: 1.5px;
                                                }
                                            </style>
                                        </defs>
                                        <title>cash-briefcase</title>
                                        <path class="a"
                                            d="M9.75,15.937c0,.932,1.007,1.688,2.25,1.688s2.25-.756,2.25-1.688S13.243,14.25,12,14.25s-2.25-.756-2.25-1.688,1.007-1.687,2.25-1.687,2.25.755,2.25,1.687">
                                        </path>
                                        <line class="a" x1="12" y1="9.75" x2="12" y2="10.875"></line>
                                        <line class="a" x1="12" y1="17.625" x2="12" y2="18.75"></line>
                                        <rect class="a" x="1.5" y="6.75" width="21" height="15" rx="1.5" ry="1.5">
                                        </rect>
                                        <path class="a"
                                            d="M15.342,3.275A1.5,1.5,0,0,0,13.919,2.25H10.081A1.5,1.5,0,0,0,8.658,3.275L7.5,6.75h9Z">
                                        </path>
                                    </svg>
                                </span>
                            </div>
                        </div> <!-- / .row -->
                    </div>
                </div>
            </div>

            {{-- Gastos --}}
            <div class="col-md-6">
                <!-- Card -->
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col d-flex justify-content-between">

                                <div>
                                    <!-- Title -->
                                    <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                        <span class="legend-circle-sm bg-danger"></span>
                                        Cuentas por cobrar
                                    </h5>

                                    <!-- Subtitle -->
                                    <h2 class="mb-0">
                                        $ @money($datos['saldo_por_cobrar'])
                                    </h2>


                                    <!-- Comment -->
                                    <p class="fs-6 text-muted mb-0">
                                        N# Cobros pendientes : {{ $datos['numero_cobros_pendientes'] }} - <a
                                            href="{{ route('dashboard.cuentas_por_cobrar_mensual_actual') }}">Ver
                                            detalles</a>
                                    </p>
                                </div>

                                <span class="text-primary">
                                    <svg viewBox="0 0 24 24" height="32" width="32" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M18.75,14.25H16.717a1.342,1.342,0,0,0-.5,2.587l2.064.826a1.342,1.342,0,0,1-.5,2.587H15.75"
                                            fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="1.5"></path>
                                        <path d="M17.25 14.25L17.25 13.5" fill="none" stroke="currentColor"
                                            stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                        </path>
                                        <path d="M17.25 21L17.25 20.25" fill="none" stroke="currentColor"
                                            stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                        </path>
                                        <path
                                            d="M11.250 17.250 A6.000 6.000 0 1 0 23.250 17.250 A6.000 6.000 0 1 0 11.250 17.250 Z"
                                            fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="1.5"></path>
                                        <path d="M3.75 14.25L8.25 14.25" fill="none" stroke="currentColor"
                                            stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                        </path>
                                        <path d="M8.25 14.25L8.25 6.75" fill="none" stroke="currentColor"
                                            stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                        </path>
                                        <path d="M11.25 9.75L11.25 8.25" fill="none" stroke="currentColor"
                                            stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                        </path>
                                        <path d="M5.25 14.25L5.25 9.75" fill="none" stroke="currentColor"
                                            stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                        </path>
                                        <path
                                            d="M7.5,20.25H2.25a1.43,1.43,0,0,1-1.5-1.415V2.335A1.575,1.575,0,0,1,2.25.75H12.879a1.5,1.5,0,0,1,1.06.439l2.872,2.872a1.5,1.5,0,0,1,.439,1.06V7.5"
                                            fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="1.5"></path>
                                    </svg>
                                </span>
                            </div>
                        </div> <!-- / .row -->
                    </div>
                </div>
            </div>
            <hr>
            <h4>Informacion total</h4>
            {{-- Remotas --}}
            <div class="col-md-6">

                <!-- Card -->
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col d-flex justify-content-between">
                                <div>
                                    <!-- Title -->
                                    <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                        <span class="legend-circle-sm bg-success"></span>
                                        Remotas totales
                                    </h5>

                                    <!-- Subtitle -->
                                    <h2 class="mb-3 ">
                                        {{ $datos['remotasTotal'] }}
                                    </h2>

                                    <!-- Comment -->
                                    <p class="fs-6 text-muted mb-0">

                                    </p>
                                </div>

                                <span class="text-primary">

                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" height="32"
                                        width="32">
                                        <!--!Font Awesome Free 6.5.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.-->
                                        <path fill="#20c3ce"
                                            d="M233 7c-9.4-9.4-24.6-9.4-33.9 0l-96 96c-9.4 9.4-9.4 24.6 0 33.9l89.4 89.4-15.5 15.5C152.3 230.4 124.9 224 96 224c-31.7 0-61.5 7.7-87.8 21.2c-9 4.7-10.3 16.7-3.1 23.8L112.7 376.7 96.3 393.1c-2.6-.7-5.4-1.1-8.3-1.1c-17.7 0-32 14.3-32 32s14.3 32 32 32s32-14.3 32-32c0-2.9-.4-5.6-1.1-8.3l16.4-16.4L242.9 506.9c7.2 7.2 19.2 5.9 23.8-3.1C280.3 477.5 288 447.7 288 416c0-28.9-6.4-56.3-17.8-80.9l15.5-15.5L375 409c9.4 9.4 24.6 9.4 33.9 0l96-96c9.4-9.4 9.4-24.6 0-33.9l-89.4-89.4 55-55c12.5-12.5 12.5-32.8 0-45.3l-48-48c-12.5-12.5-32.8-12.5-45.3 0l-55 55L233 7zm159 351l-72.4-72.4 62.1-62.1L454.1 296 392 358.1zM226.3 192.4L153.9 120 216 57.9l72.4 72.4-62.1 62.1z" />
                                    </svg>
                                </span>
                            </div>
                        </div> <!-- / .row -->
                        <div class="row">
                            <div class="table-responsive">

                                <table class="table table-striped table-bordered w-100">
                                    <thead class="thead-dark text-center">
                                        <tr>
                                            <th scope="col">Activas</th>
                                            <th scope="col">Inactivas</th>
                                            <th scope="col">Pausadas</th>
                                            <th scope="col">Pausada Por pago</th>

                                        </tr>
                                    </thead>
                                    <tbody class="text-center">
                                        <tr>
                                            <th class="bg-info">{{ $datos['remotasActivas'] }}</th>
                                            <td>{{ $datos['remotasInactivas'] }}</td>
                                            <td>{{ $datos['remotasPausadas'] }}</td>
                                            <td> {{ $datos['remotasPausadasPorPago'] }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            {{-- Total --}}
            <div class="col-md-6">
                <!-- Card -->
                <div class="card border-0" style="cursor: pointer;" onclick="window.location.href='{{ route('totales.mensuales') }}'">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6">

                                <!-- Title -->
                                <h5 class="text-uppercase text-muted fw-semibold mb-2">
                                    Total
                                </h5>

                                <!-- Subtitle -->
                                <h2 class="mb-0">
                                    $ @money($datos['total_cobranzas'])
                                </h2>

                                <!-- Comment -->
                                <p class="fs-6 text-muted mb-0 text-truncate">
                                    @if($datos['total_anterior'] > 0)
                                        <!-- Badge -->
                                        <span class="badge {{ $datos['rendimiento'] >= 0 ? 'text-bg-success-soft' : 'text-bg-danger-soft' }} fs-6 fw-bold mb-n1">
                                            <svg viewBox="0 0 24 24" height="10" width="10"
                                                xmlns="http://www.w3.org/2000/svg">
                                                @if($datos['rendimiento'] >= 0)
                                                    <path d="M23.25 12.75L23.25 6 16.5 6" fill="none" stroke="currentColor"
                                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                                    </path>
                                                    <path
                                                        d="M23.25,6l-7.939,7.939a1.5,1.5,0,0,1-2.122,0l-3.128-3.128a1.5,1.5,0,0,0-2.122,0L.75,18"
                                                        fill="none" stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" stroke-width="1.5"></path>
                                                @else
                                                    <path d="M0.75 11.25L0.75 18 7.5 18" fill="none" stroke="currentColor"
                                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                                    </path>
                                                    <path
                                                        d="M0.75,18l7.939-7.939a1.5,1.5,0,0,1 2.122,0l3.128,3.128a1.5,1.5,0,0,0 2.122,0L23.25,6"
                                                        fill="none" stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" stroke-width="1.5"></path>
                                                @endif
                                            </svg>
                                            {{ $datos['rendimiento'] >= 0 ? '+' : '' }}{{ number_format($datos['rendimiento'], 1) }}%
                                        </span>
                                        desde $@money($datos['total_anterior'])
                                    @else
                                        <span class="text-muted">Sin datos del mes anterior</span>
                                    @endif
                                </p>
                            </div>

                            <div class="col-6">

                                <!-- Chart -->
                                <div class="chart-container h-70px">
                                    <canvas id="incomeChart"
                                        style="display: block; box-sizing: border-box; height: 70px; width: 123px;"
                                        width="138" height="78"></canvas>
                                </div>
                            </div>
                        </div> <!-- / .row -->
                    </div>
                </div>
            </div>

        </div> <!-- / .row -->

        <div class="card ">
            <div class="m-3">

                {{-- @livewire('clientes-datatable') --}}
                <table id="Clientespreview" class="table  table-bordered datatable2">
                    <thead>
                        <tr>
                            {{-- <th>Identidad</th> --}}
                            <th>Cliente</th>
                            <th>Numero de remotas activas</th>
                            <th>Deuda total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($datos['clientes'] as $cliente)
                        @if ($cliente->remotasActivas()->count() ==0)
                        @continue
                        @else
                        <tr>
                            {{-- <td>{{ $cliente->getIdentity()??'N/R' }}</td> --}}
                            <td>{{ $cliente->getClientName() }}</td>
                            <td>
                                @if ($cliente->remotasActivas()->count() == $cliente->remotas()->count())
                                {{ $cliente->remotasActivas()->count() }}
                                @else
                                {{ $cliente->remotasActivas()->count() }} / <strong class="text-secondary">{{
                                    $cliente->remotas()->count() }}</strong>

                                @endif
                            </td>
                            {{-- <td>$@money($cliente->montoPendienteRemotasActivas()->sum('costo'))</td> --}}
                            <td>$@money($cliente->montoPendienteRemotasActivas())</td>
                        </tr>

                        @endif

                        @empty
                        No hay remotas
                        @endforelse

                    </tbody>

                </table>
                <small class="text-muted text-sm">Deuda total hasta el dia de hoy ( {{
                    Carbon\Carbon::now()->format('d/m/Y
                    H:m:s' ) }} )</small>

            </div>
        </div>

    </div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        localStorage.removeItem('loginAttempts');
        localStorage.setItem('fromLogout', 'true');
    });
</script>

</x-app-layout>
{{-- <script>
    $(document).ready( function () {
    $('.datatable').DataTable({
        "order": [[ 2, "desc" ]],
        "language": {
                    "sProcessing": "Procesando...",
                    "sLengthMenu": "Mostrar _MENU_ registros",
                    "sZeroRecords": "No se encontraron resultados",
                    "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
                    "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
                    "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sSearch": "Buscar:",
                    "sUrl": "",
                    "sEmptyTable": "No hay datos disponibles en la tabla",
                    "sLoadingRecords": "Cargando...",
                    "oPaginate": {
                        "sFirst": "Primero",
                        "sLast": "Último",
                        "sNext": "Siguiente",
                        "sPrevious": "Anterior"
                    },
                    "oAria": {
                        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
                    },
        }});
    });

</script> --}}
<script>
    $(document).ready(function () {
        var dataTableConfig = {
            "order": [[2, "desc"]],
            // "ordering": false, // Desactiva el ordenamiento por defecto

            "pageLength": 25,
            "language": {
                "sProcessing": "Procesando...",
                "sLengthMenu": "Mostrar _MENU_ registros",
                "sZeroRecords": "No se encontraron resultados",
                "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
                "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
                "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
                "sSearch": "Buscar:",
                "sEmptyTable": "No hay datos disponibles en la tabla",
                "sLoadingRecords": "Cargando...",
                "oPaginate": {
                    "sFirst": "Primero",
                    "sLast": "Último",
                    "sNext": "Siguiente",
                    "sPrevious": "Anterior"
                },
                "oAria": {
                    "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                    "sSortDescending": ": Activar para ordenar la columna de manera descendente"
                }
            }
        };

        // Inicializar DataTable con la configuración guardada en la variable
        $('.datatable2').DataTable(dataTableConfig);
    });
</script>
