<x-app-layout>

    @section('title', 'Configuraciones')

    <div class="container pt-2">

        @php
            $TimeUtils = \App\Classes\TimeUtils::class;
            $TipoConfiguracion = \App\Enums\TipoConfiguracion::class;
        @endphp

        <header class="mb-4">
            <h1 class="text-center h1">Configuraciones</h1>
        </header>
        <div class="d-flex justify-content-end gap-2 wrap mb-2">
            <button id="edit-all-btn" class="action-btn btn btn-outline-primary rounded" title="Editar" type="button"
                data-bs-toggle="tooltip" data-bs-title="Editar">
                <svg viewBox="0 0 24 24" height="24" width="24" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M22.63,14.87,15,22.5l-3.75.75L12,19.5l7.63-7.63a2.114,2.114,0,0,1,2.992,0l.008.008A2.114,2.114,0,0,1,22.63,14.87Z"
                        fill="none" fill="none" stroke="currentColor" stroke-linecap="round"
                        stroke-linejoin="round" stroke-width="1" />
                    <path d="M3.75 6.75L14.25 6.75" fill="none" stroke="currentColor" stroke-linecap="round"
                        stroke-linejoin="round" stroke-width="1" />
                    <path d="M3.75 11.25L14.25 11.25" fill="none" stroke="currentColor" stroke-linecap="round"
                        stroke-linejoin="round" stroke-width="1" />
                    <path d="M3.75 15.75L9 15.75" fill="none" stroke="currentColor" stroke-linecap="round"
                        stroke-linejoin="round" stroke-width="1" />
                </svg>
            </button>
            <button id="accept-all-btn" class="action-btn btn btn-outline-success rounded d-none" title="Aceptar"
                type="button" data-bs-toggle="tooltip" data-bs-title="Aceptar">
                <svg viewBox="0 0 24 24" height="24" width="24" xmlns="http://www.w3.org/2000/svg">
                    <path d="M11.250 17.250 A6.000 6.000 0 1 0 23.250 17.250 A6.000 6.000 0 1 0 11.250 17.250 Z"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                        stroke-width="1" />
                    <path d="M19.924,15.505l-2.905,3.874a.752.752,0,0,1-1.131.081l-1.5-1.5" fill="none"
                        stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1" />
                    <path
                        d="M8.25,20.25h-6a1.5,1.5,0,0,1-1.5-1.5V2.25A1.5,1.5,0,0,1,2.25.75H12.879a1.5,1.5,0,0,1,1.06.439l2.872,2.872a1.5,1.5,0,0,1,.439,1.06V8.25"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                        stroke-width="1" />
                </svg>
            </button>
            <button id="cancel-all-btn" class="action-btn btn btn-outline-danger rounded d-none" title="Cancelar"
                type="button" data-bs-toggle="tooltip" data-bs-title="Cancelar">
                <svg viewBox="0 0 24 24" height="24" width="24" xmlns="http://www.w3.org/2000/svg">
                    <path d="M11.250 17.250 A6.000 6.000 0 1 0 23.250 17.250 A6.000 6.000 0 1 0 11.250 17.250 Z"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                        stroke-width="1" />
                    <path d="M13.008 21.491L21.492 13.008" fill="none" stroke="currentColor" stroke-linecap="round"
                        stroke-linejoin="round" stroke-width="1" />
                    <path
                        d="M8.25,20.25h-6a1.5,1.5,0,0,1-1.5-1.5V2.25A1.5,1.5,0,0,1,2.25.75H12.879a1.5,1.5,0,0,1,1.06.439l2.872,2.872a1.5,1.5,0,0,1,.439,1.06V8.25"
                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                        stroke-width="1" />
                </svg>
            </button>
        </div>

        <table id="config-table" class="table">
            <thead>
                <tr>
                    <th scope="col" class="text-center">Nombre</th>
                    <th scope="col" class="text-center">Descripcion</th>
                    <th scope="col" class="text-center">Valor</th>
                    <th scope="col" class="text-center">Última Actualización</th>
                    <th scope="col" class="text-center">Acción</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($configuraciones as $configuracion)
                    <tr>
                        <td class="fw-bold">{{ $configuracion->display_name }}</td>
                        <td>{{ $configuracion->descripcion }}</td>
                        <td>
                            <span>
                                {{ $configuracion->valor }}
                            </span>
                            @switch($configuracion->tipo)
                                @case($TipoConfiguracion::ARCHIVO->value)
                                    <input type="file" class="d-none form-control" name="{{ $configuracion->uuid }}">
                                @break

                                @case($TipoConfiguracion::NUMERO->value)
                                    <input type="number" class="d-none form-control" name="{{ $configuracion->uuid }}">
                                @break

                                @case($TipoConfiguracion::IMAGEN->value)
                                    <input type="file" accept="image/*" class="d-none form-control"
                                        name="{{ $configuracion->uuid }}">
                                @break

                                @case($TipoConfiguracion::TEXTO->value)
                                    <input type="text" class="d-none form-control" name="{{ $configuracion->uuid }}">
                                @break

                                @case($TipoConfiguracion::BOOL->value)
                                    <input type="checkbox" name="{{ $configuracion->uuid }}" class="form-check-input d-none"
                                        value="true" @checked($configuracion->valor == 'true')>
                                @break

                                @default
                                    <input type="text" class="d-none" name="{{ $configuracion->uuid }}" />
                            @endswitch
                        </td>
                        <td class="text-center">{{ $TimeUtils::standartDateTimeFormat($configuracion->updated_at) }}
                        </td>
                        <td>
                            <button class="action-btn edit-btn btn btn-outline-primary rounded" title="Editar"
                                type="button" data-bs-toggle="tooltip" data-bs-title="Editar">
                                <svg viewBox="0 0 24 24" height="24" width="24"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M22.63,14.87,15,22.5l-3.75.75L12,19.5l7.63-7.63a2.114,2.114,0,0,1,2.992,0l.008.008A2.114,2.114,0,0,1,22.63,14.87Z"
                                        fill="none" fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="1" />
                                    <path d="M3.75 6.75L14.25 6.75" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="1" />
                                    <path d="M3.75 11.25L14.25 11.25" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="1" />
                                    <path d="M3.75 15.75L9 15.75" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="1" />
                                </svg>
                            </button>
                            <button class="action-btn accept-btn btn btn-outline-success rounded d-none"
                                title="Aceptar" type="button" data-bs-toggle="tooltip" data-bs-title="Aceptar">
                                <svg viewBox="0 0 24 24" height="24" width="24"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M11.250 17.250 A6.000 6.000 0 1 0 23.250 17.250 A6.000 6.000 0 1 0 11.250 17.250 Z"
                                        fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="1" />
                                    <path d="M19.924,15.505l-2.905,3.874a.752.752,0,0,1-1.131.081l-1.5-1.5"
                                        fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="1" />
                                    <path
                                        d="M8.25,20.25h-6a1.5,1.5,0,0,1-1.5-1.5V2.25A1.5,1.5,0,0,1,2.25.75H12.879a1.5,1.5,0,0,1,1.06.439l2.872,2.872a1.5,1.5,0,0,1,.439,1.06V8.25"
                                        fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="1" />
                                </svg>
                            </button>
                            <button class="action-btn cancel-edit-btn btn btn-outline-danger rounded d-none"
                                title="Cancelar" type="button" data-bs-toggle="tooltip" data-bs-title="Cancelar">
                                <svg viewBox="0 0 24 24" height="24" width="24"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M11.250 17.250 A6.000 6.000 0 1 0 23.250 17.250 A6.000 6.000 0 1 0 11.250 17.250 Z"
                                        fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="1" />
                                    <path d="M13.008 21.491L21.492 13.008" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="1" />
                                    <path
                                        d="M8.25,20.25h-6a1.5,1.5,0,0,1-1.5-1.5V2.25A1.5,1.5,0,0,1,2.25.75H12.879a1.5,1.5,0,0,1,1.06.439l2.872,2.872a1.5,1.5,0,0,1,.439,1.06V8.25"
                                        fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="1" />
                                </svg>
                            </button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        @push('scripts')
            @vite(['resources/js/modules/configuracion/configuracion.js'])
        @endpush
    </div>
</x-app-layout>
