@props(['name', 'title'])

<div x-data="{ show : false , name : '{{ $name }}' }" x-show="show"
    x-on:open-modal.window="show = ($event.detail.name === name)" x-on:close-modal.window="show = false"
    x-on:keydown.escape.window="show = false" style="display:none;" class="fixed z-50 inset-0" x-transition.duration>

    {{-- Gray Background --}}
    <div x-on:click="show = false" class="fixed inset-0 bg-dark opacity-50"></div>

    {{-- Modal Body --}}
    <div class="modal-dialog modal-dialog-centered card p-3" role="document">
        <div class="modal-content">
            @if (isset($title))
            <div class="modal-header">
                <h5 class="modal-title">{{ $title }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                    x-on:click="$dispatch('close-modal')"></button>
            </div>
            @endif
            <div class="modal-body">
                {{ $body }}
            </div>
        </div>
    </div>
</div>