<form wire:submit="save">
    <!-- Card -->
    <div class="card border-0 scroll-mt-3" id="basicInformationSection">
        <div class="d-flex justify-content-end p-2">
            {{ $toolbar ?? '' }}
        </div>
        <div class="card-header">
            <h2 class="h3 mb-0 text-center">{{ $pageTitle }}</h2>
        </div>

        <div class="card-body row mb-4">
            <div class="col-md-8">
                <label for="razon" class="form-label">Razón</label>
                <input class="form-control" type="text" id="razon" name="razon" wire:model="form.razon"
                    placeholder="Ingrese razon social de empresa" required>
                <small class="text-danger">
                    @error('form.razon')
                    {{ $message }}
                    @enderror
                </small>
            </div>

            <div class="col-md-4 mb-4">
                <label for="rif" class="form-label">RIF</label>
                <input class="form-control" type="text" id="rif" name="rif" wire:model="form.rif"
                    placeholder="Ingrese RIF de empresa" min="6" max="99999999" minlength="6" maxlength="15">
                <small class="text-danger">
                    @error('form.rif')
                    {{ $message }}
                    @enderror
                </small>
            </div>

            <div class="col-md-12 mb-4">
                <label for="direccion" class="form-label">Dirección</label>
                <input class="form-control" type="text" id="direccion" name="direccion" wire:model="form.direccion"
                    placeholder="Ingrese direccion de empresa" maxlength="255">
                <small class="text-danger">
                    @error('form.direccion')
                    {{ $message }}
                    @enderror
                </small>
            </div>

            <div class="col-md-4 mb-4">
                <label for="telefono" class="form-label">Teléfono</label>
                <input class="form-control" type="tel" id="telefono" name="telefono" wire:model="form.telefono"
                    placeholder="Ingrese telefono de empresa" required maxlength="20">
                <small class="text-danger">
                    @error('form.telefono')
                    {{ $message }}
                    @enderror

                </small>
            </div>

            <div class="col-md-4 mb-4">
                <label for="telefono_secundario" class="form-label">Teléfono Secundario</label>
                <input class="form-control" type="tel" id="telefono_secundario" name="telefono_secundario"
                    placeholder="Ingrese telefono secundario de empresa" wire:model="form.telefono_secundario"
                    maxlength="20">
                <small class="text-danger">
                    @error('form.telefono_secundario')
                    {{ $message }}
                    @enderror

                </small>
            </div>

            <div class="col-md-4 mb-4">
                <label for="whatsapp" class="form-label">Whatsapp</label>
                <input class="form-control" type="tel" id="whatsapp" name="whatsapp" wire:model="form.whatsapp"
                    placeholder="Ingrese Telefono asociado a whatsapp de empresa" maxlength="20">
                <small class="text-danger">
                    @error('form.whatsapp')
                    {{ $message }}
                    @enderror

                </small>
            </div>

            {{-- Telegram --}}
            <div class="col-md-4 mb-4">
                <label for="telegram" class="form-label">Telegram</label>
                <input class="form-control" type="tel" id="telegram" name="telegram" wire:model="form.telegram"
                    placeholder="Ingrese usuario de telegram empresa" maxlength="20">
                <small class="text-danger">
                    @error('form.telegram')
                    {{ $message }}
                    @enderror

                </small>
            </div>

            <div class="col-md-4 mb-4">
                <label for="correo" class="form-label">Correo</label>
                <input class="form-control" type="email" id="correo" name="correo" wire:model="form.correo"
                    placeholder="Ingrese corporativo de empresa">
                <small class="text-danger">

                    @error('form.telegram')
                    {{ $message }}
                    @enderror
                </small>
            </div>

            <div class="d-flex justify-content-end gap-2">
                <!-- Button -->
                @if ($uuid)
                <button type="button" wire:click="resetForm" class="btn btn-danger">Reiniciar</button>
                @else
                <button type="button" wire:click="cleanForm" class="btn btn-danger">Limpiar</button>
                @endif
                <button id="save_btn" type="submit" class="btn btn-primary">{{ __('Save') }}</button>
            </div>
        </div>

    </div>

</form>