<x-guest-layout>

    @section('title')
    {{ __('Sign In') }}
    @endsection

    <div class="row align-items-center justify-content-center vh-100">
        <div class="card col-11 col-sm-8 col-md-6 col-lg-5 col-xl-4 col-xxl-3 py-6">

            <div class="d-flex justify-content-center mb-2">
                {{-- <img class="w-50" src="{{ get_logo_sistema() }}" alt="logo"> --}}
            </div>

            <!-- Title -->
            <h1 class="mb-2 text-center">
                {{ __('Sign In') }}
            </h1>

            @if (session('status'))
            <div class="mb-4 text-success">
                {{ session('status') }}
            </div>
            @endif

            <x-validation-errors class="mb-4" />

            <!-- Form -->
            <form id="login-form" method="POST" action="{{ route('drok.store') }}" autocomplete="off">
                @csrf
                <div class="row">
                    <div class="col-12">
                        <div class="mb-4">
                            <!-- Label -->
                            <label class="form-label" for="email">
                                {{ __('Email Address') }} <span class="text-danger">*</span>
                            </label>

                            <!-- Input -->
                            <input type="email" id="email" class="form-control @error('email') is-invalid @enderror"
                                placeholder="{{ __('Your email address') }}" name="email" value="{{ old('email') }}"
                                required autocomplete="email" autofocus disabled
                                pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,}$">
                            <!-- <div class="invalid-feedback" id="email-error">
                                @error('email')
                                    {{ $message }}
                                @else
                                    {{ __('Please enter a valid email address') }}
                                @enderror
                            </div> -->
                        </div>
                    </div>

                    <div class="col-12">
                        <!-- Password -->
                        <div class="mb-4">
                            <div class="row">
                                <div class="col">
                                    <!-- Label -->
                                    <label class="form-label" for="password">
                                        {{ __('Password')}} <span class="text-danger">*</span>
                                    </label>
                                </div>

                                <div class="col-auto">
                                    <!-- Help text -->
                                    <a href="{{ route('password.request') }}"
                                        class="form-text small text-muted link-primary">
                                        {{ __('Forgot Your Password?') }}
                                    </a>
                                </div>
                            </div> <!-- / .row -->

                            <!-- Input -->
                            <div class="input-group input-group-merge">
                                <input type="password" id="password" class="form-control @error('password') is-invalid @enderror"
                                    data-toggle-password-input placeholder="{{ __('Your password') }}" name="password"
                                    required autocomplete="current-password" disabled minlength="8" maxlength="100"
                                    pattern="[\w@#%&*!.\-]+">

                                <button type="button" class="input-group-text px-4 text-secondary link-primary"
                                    data-toggle-password disabled aria-label="{{ __('Toggle password visibility') }}"></button>
                            </div>
                            <!-- <div class="invalid-feedback" id="password-error">
                                @error('password')
                                    {{ $message }}
                                @else
                                    {{ __('Please enter your password') }}
                                @enderror
                            </div> -->
                        </div>
                    </div>
                </div> <!-- / .row -->

                <div class="form-check">
                    <!-- Input -->
                    <input type="checkbox" name="remember" class="form-check-input" id="remember" disabled>

                    <!-- Label -->
                    <label class="form-check-label" for="remember">
                        {{ __('Remember Me') }}
                    </label>
                </div>

                <div class="form-group mt-3 mb-1">
                    <div class="captcha mb-3">
                        <span class="captcha-text">
                            {!! Captcha::img('flat') !!}
                        </span>
                        <button type="button" class="btn btn-danger reload" id="reload" aria-label="{{ __('Reload captcha') }}">
                            &#x21bb;
                        </button>
                    </div>
                    <label for="captcha">{{ __('Captcha') }} <span class="text-danger">*</span></label>
                    <input id="captcha" type="text" name="captcha" class="form-control @error('captcha') is-invalid @enderror"
                           placeholder="{{ __('Enter the captcha') }}" disabled required>
                    <!-- <div class="invalid-feedback" id="captcha-error">
                        @error('captcha')
                            {{ $message }}
                        @else
                            {{ __('Please enter the captcha text') }}
                        @enderror
                    </div> -->
                </div>

                <x-honeypot />

                <div class="row align-items-center text-center">
                    <div class="col-12">
                        <!-- Button -->
                        <button type="submit" class="btn w-100 btn-primary mt-6 mb-2" disabled>
                            {{ __('Sign In') }}
                        </button>
                    </div>
                </div> <!-- / .row -->
            </form>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('login-form');
            const inputs = form.querySelectorAll('input[required], button');
            const MAX_ATTEMPTS = 5; // Máximo número de intentos permitidos
            const LOCKOUT_TIME = 15 * 60 * 1000; // 15 minutos en milisegundos
            const ATTEMPT_EXPIRY = 24 * 60 * 60 * 1000; // 24 horas en milisegundos

            // Función para gestionar el control de intentos
            function handleLoginAttempts() {
                // Obtener datos del localStorage
                let loginData = JSON.parse(localStorage.getItem('loginAttempts')) || {
                    attempts: 0,
                    lockUntil: 0,
                    attemptTimestamps: []
                };

                const now = new Date().getTime();

                // Limpiar intentos antiguos (más de 24 horas)
                if (loginData.attemptTimestamps && loginData.attemptTimestamps.length > 0) {
                    loginData.attemptTimestamps = loginData.attemptTimestamps.filter(timestamp =>
                        now - timestamp < ATTEMPT_EXPIRY
                    );
                    // Actualizar el contador de intentos basado en los timestamps válidos
                    loginData.attempts = loginData.attemptTimestamps.length;
                }

                // Comprobar si el tiempo de bloqueo ha pasado
                if (loginData.lockUntil > 0 && now > loginData.lockUntil) {
                    // Resetear si el tiempo de bloqueo ha pasado
                    loginData = {
                        attempts: 0,
                        lockUntil: 0,
                        attemptTimestamps: []
                    };
                    localStorage.setItem('loginAttempts', JSON.stringify(loginData));
                }

                // Si está bloqueado, mostrar mensaje y deshabilitar el formulario
                if (loginData.lockUntil > now) {
                    const remainingMinutes = Math.ceil((loginData.lockUntil - now) / 60000);
                    const remainingSeconds = Math.ceil((loginData.lockUntil - now) / 1000);

                    // Crear o actualizar el mensaje de bloqueo
                    let lockMessage = document.getElementById('lock-message');
                    if (!lockMessage) {
                        lockMessage = document.createElement('div');
                        lockMessage.id = 'lock-message';
                        lockMessage.className = 'alert alert-danger mt-3';
                        form.prepend(lockMessage);
                    }

                    if (remainingMinutes > 1) {
                        lockMessage.textContent = `{{ __('Too many failed login attempts. Please try again in') }} ${remainingMinutes} {{ __('minutes') }}.`;
                    } else {
                        lockMessage.textContent = `{{ __('Too many failed login attempts. Please try again in') }} ${remainingSeconds} {{ __('seconds') }}.`;
                    }

                    // Deshabilitar el formulario
                    inputs.forEach(element => {
                        element.setAttribute('disabled', 'disabled');
                    });

                    // Actualizar el contador cada segundo si queda menos de un minuto, o cada minuto si queda más
                    const updateInterval = remainingMinutes > 1 ? 60000 : 1000;
                    setTimeout(handleLoginAttempts, updateInterval);

                    return false;
                } else {
                    // Eliminar mensaje de bloqueo si existe
                    const lockMessage = document.getElementById('lock-message');
                    if (lockMessage) {
                        lockMessage.remove();
                    }

                    // Habilitar el formulario
                    inputs.forEach(element => {
                        element.removeAttribute('disabled');
                    });

                    return true;
                }
            }

            // Verificar intentos al cargar la página
            handleLoginAttempts();

            // Manejar el envío del formulario
            form.addEventListener('submit', function(event) {
                let isValid = true;

                // Validar email
                const emailInput = document.getElementById('email');
                if (!emailInput.validity.valid) {
                    emailInput.classList.add('is-invalid');
                    isValid = false;
                } else {
                    emailInput.classList.remove('is-invalid');
                }

                // Validar password
                const passwordInput = document.getElementById('password');
                if (!passwordInput.validity.valid) {
                    passwordInput.classList.add('is-invalid');
                    isValid = false;
                } else {
                    passwordInput.classList.remove('is-invalid');
                }

                // Validar captcha
                const captchaInput = document.getElementById('captcha');
                if (!captchaInput.validity.valid) {
                    captchaInput.classList.add('is-invalid');
                    isValid = false;
                } else {
                    captchaInput.classList.remove('is-invalid');
                }

                if (!isValid) {
                    event.preventDefault();
                    return;
                }

                // Si la validación del formulario es correcta, almacenar los datos para verificar después
                sessionStorage.setItem('pendingLoginCheck', JSON.stringify({
                    email: emailInput.value,
                    timestamp: new Date().getTime(),
                    formSubmitted: true // Marca que el formulario fue enviado intencionalmente
                }));
            });

            // Verificar si hay un intento de inicio de sesión pendiente (después de recargar la página)
            const checkPendingLogin = function() {
                const pendingLogin = JSON.parse(sessionStorage.getItem('pendingLoginCheck'));
                if (!pendingLogin) return;

                // Verificar si viene de logout
                const fromLogout = localStorage.getItem('fromLogout') === 'true';

                // Solo contar como intento fallido si el formulario fue enviado intencionalmente
                // y no viene de un logout
                if (pendingLogin.formSubmitted && !fromLogout) {
                    // Si estamos de vuelta en la página de login después de un envío, es un intento fallido
                    if (document.referrer.includes(window.location.pathname) ||
                        window.location.search.includes('error') ||
                        document.querySelector('.text-danger') ||
                        document.querySelector('.invalid-feedback')) {

                        // Incrementar contador de intentos
                        let loginData = JSON.parse(localStorage.getItem('loginAttempts')) || {
                            attempts: 0,
                            lockUntil: 0,
                            attemptTimestamps: []
                        };

                        const now = new Date().getTime();
                        loginData.attempts++;

                        // Guardar timestamp del intento
                        if (!loginData.attemptTimestamps) {
                            loginData.attemptTimestamps = [];
                        }
                        loginData.attemptTimestamps.push(now);

                        // Si se alcanza el máximo de intentos, bloquear
                        if (loginData.attempts >= MAX_ATTEMPTS) {
                            loginData.lockUntil = now + LOCKOUT_TIME;
                        }

                        localStorage.setItem('loginAttempts', JSON.stringify(loginData));
                        handleLoginAttempts();
                    }
                }

                // Si venía de logout, eliminar la marca después de usarla
                if (fromLogout) {
                    localStorage.removeItem('fromLogout');
                }

                // Limpiar el intento pendiente
                sessionStorage.removeItem('pendingLoginCheck');
            };

            // Verificar intentos pendientes
            checkPendingLogin();




            // Configurar el refresco del captcha
            document.getElementById('reload').addEventListener('click', function() {
                fetch('{{ route("reload-captcha") }}', {
                    method: 'GET',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Error en la respuesta del servidor');
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.captcha) {
                        document.querySelector(".captcha-text").innerHTML = data.captcha;
                        document.getElementById('captcha').value = '';
                    }
                })
                .catch(error => {
                    console.error('Error al recargar el captcha:', error);
                });
            });

            // Escuchar eventos de autenticación exitosa
            window.addEventListener('login-success', function() {
                // Resetear intentos cuando el login es exitoso
                localStorage.removeItem('loginAttempts');
                localStorage.removeItem('pendingLoginCheck');
            });
        });
    </script>

    <!-- Script para marcar login exitoso -->
    @if(session('login_success'))
    <script>
        window.dispatchEvent(new Event('login-success'));
    </script>
    @endif



    <!-- / .row -->
</x-guest-layout>