import axios from "axios";
import Swal from "sweetalert2";

const btnsEdit = document.querySelectorAll('.edit-btn');
const btnsCancel = document.querySelectorAll('.cancel-edit-btn');
const btnsAccept = document.querySelectorAll('.accept-btn');
const btnEditAll = document.getElementById('edit-all-btn');
const btnCancelAll = document.getElementById('cancel-all-btn');
const btnAcceptAll = document.getElementById('accept-all-btn');
const PATCH_PATH = '/configuraciones';


function editConfig() {
    const parent = this.closest('tr');
    const btn_accept = parent.querySelector('.accept-btn');
    const btn_cancel = parent.querySelector('.cancel-edit-btn');
    const span = parent.querySelector('span');
    const input = parent.querySelector('input');

    if(input.type == 'text' || input.type == 'number') {
        input.value = span.textContent.trim();
    }

    span.classList.add('d-none');
    input.classList.remove('d-none');
    btn_accept.classList.remove('d-none');
    btn_cancel.classList.remove('d-none');
    this.classList.add('d-none');

}

function cancelConfig() {
    const parent = this.closest('tr');
    const btn_accept = parent.querySelector('.accept-btn');
    const btn_edit = parent.querySelector('.edit-btn');
    const input = parent.querySelector('input');
    const span = parent.querySelector('span');

    span.classList.remove('d-none');
    input.value = '';
    input.classList.add('d-none');
    btn_accept.classList.add('d-none');
    btn_edit.classList.remove('d-none');
    this.classList.add('d-none');
}

function saveConfig() {
    const parent = this.closest('tr');
    const input = parent.querySelector('input');

    const formData = new FormData();

    if(input.type == 'checkbox') {
        formData.append(input.name, input.checked);
    } else if(input.type == 'file') {
        formData.append(input.name, input.files[0]);
    } else {
        formData.append(input.name, input.value);
    }

    formData.append('_method', 'PATCH');

    axios.post(PATCH_PATH, formData, {
        headers: {
          "Content-Type": "multipart/form-data",
        },
      })
    .then( resp => {
        Swal.fire({
            title: resp.data.title,
            text: resp.data.message,
            icon: 'success'
        });

        if(input.type == 'checkbox') {
            parent.querySelector('span').textContent = input.checked;
        } else {
            parent.querySelector('span').textContent = input.value;
        }
        document.querySelector('.validation-error')?.remove();
        parent.querySelector('.cancel-edit-btn').click();
    })
    .catch( err => {

        if(err.response.status == 500) {
            Swal.fire({
                title: err.data.title,
                text: err.data.message,
                icon: 'error'
            });
        } else if(err.response.status == 400) {

            let validationError = document.querySelector('.validation-error');
            const validationTemplate = document.getElementById('validation-error-template').content.cloneNode(true);

            if(!validationError) {
                validationError = validationTemplate.cloneNode(true);
            }

            validationError.querySelector('ul').innerHTML = '';

            const fragment = document.createDocumentFragment();
            const response = err.response.data.data
            for(const data in response) {
                for(const error of response[data]) {
                    const li = validationTemplate.querySelector('li').cloneNode(true);
                    li.append(error);
                    fragment.append(li);
                }
            }
            validationError.querySelector('ul').append(fragment);
            document.querySelector('header').append(validationError);

        }

    });

}

function editAll() {
    btnsEdit.forEach( el => el.click() );
    btnAcceptAll.classList.remove('d-none');
    btnCancelAll.classList.remove('d-none');
    this.classList.add('d-none');
}

function cancelAll() {
    btnsCancel.forEach(el => el.click());
    btnAcceptAll.classList.add('d-none');
    btnEditAll.classList.remove('d-none');
    this.classList.add('d-none');
}

function saveAll() {
    const table = document.getElementById('config-table');
    const inputs = table.querySelectorAll('input:not(.d-none)');

    const formData = new FormData();

    inputs.forEach( input => {
        if(input.type == 'checkbox') {
            formData.append(input.name, input.checked);
        } else if(input.type == 'file') {
            formData.append(input.name, input.files[0]);
        } else {
            formData.append(input.name, input.value);
        }
    });

    formData.append('_method', 'PATCH');

    axios.post(PATCH_PATH, formData, {
        headers: {
          "Content-Type": "multipart/form-data",
        },
      })
    .then( resp => {
        Swal.fire({
            title: resp.data.title,
            text: resp.data.message,
            icon: 'success'
        });

        try {
            inputs.forEach( input => {
                const parent = input.closest('tr');
                if(input.type == 'checkbox') {
                    parent.querySelector('span').textContent = input.checked;
                } else {
                    parent.querySelector('span').textContent = input.value;
                }
            });
            document.querySelector('.validation-error')?.remove();
            btnCancelAll.click();

        } catch (err) {
            console.error(err);
        }
    })
    .catch( err => {

        if(err.response.status == 500) {
            Swal.fire({
                title: err.data.title,
                text: err.data.message,
                icon: 'error'
            });
        } else if(err.response.status == 400) {

            let validationError = document.querySelector('.validation-error');
            const validationTemplate = document.getElementById('validation-error-template').content.cloneNode(true);

            if(!validationError) {
                validationError = validationTemplate.cloneNode(true);
            }

            validationError.querySelector('ul').innerHTML = '';

            const fragment = document.createDocumentFragment();
            const response = err.response.data.data
            for(const data in response) {
                for(const error of response[data]) {
                    const li = validationTemplate.querySelector('li').cloneNode(true);
                    li.append(error);
                    fragment.append(li);
                }
            }
            validationError.querySelector('ul').append(fragment);
            document.querySelector('header').append(validationError);

        }

    });

}

btnsEdit.forEach( el => el.addEventListener('click', editConfig) );
btnsCancel.forEach( el => el.addEventListener('click', cancelConfig) );
btnsAccept.forEach( el => el.addEventListener('click', saveConfig) );

btnEditAll.addEventListener('click', editAll);
btnCancelAll.addEventListener('click', cancelAll);
btnAcceptAll.addEventListener('click', saveAll);
