<?php

namespace Database\Seeders;

use App\Models\Empresa;
use App\Models\Proveedor;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ProveedorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Datos falsos
        // Proveedor::factory(2)->create();

        DB::table('empresas')->insert([
            [
                'razon' => 'CANTV',
                'direccion' => 'altavista',
                'rif' => 'J-62421758136',
                'telefono' => '0424961111111',
                'correo' =>  "cantv@gmail.com",
                'uuid' => '89647481362183'
            ],
        ]);
        DB::table('proveedores')->insert([
            [
                'empresa_id' => Empresa::where('razon', '=', 'CANTV')->first()->id,
            ],
        ]);

        DB::table('planes')->insert([
            [
                'nombre' => 'Bronze - CANTV',
                'uuid' => '89647481362183',
                'costo' => 250,

                'precio' => 1000,
                'proveedor_id' => Proveedor::where('empresa_id', '=', Empresa::where('razon', '=', 'CANTV')->first()->id)->first()->id,
            ],
        ]);
        DB::table('planes')->insert([
            [
                'nombre' => 'Silver - CANTV',
                'uuid' => '89647481362183',
                'costo' => 100,

                'precio' => 200,
                'proveedor_id' => Proveedor::where('empresa_id', '=', Empresa::where('razon', '=', 'CANTV')->first()->id)->first()->id,
            ],
        ]);

        DB::table('empresas')->insert([
            [
                'razon' => 'CLOUDSAT',
                'direccion' => 'altavista',

                'rif' => 'J-42342343',
                'telefono' => '3213213214',
                'correo' =>  "CLOUDSAT@gmail.com",
                'uuid' => '89647481362133232483'

            ],
        ]);
        DB::table('proveedores')->insert([
            [
                'empresa_id' => Empresa::where('razon', '=', 'CLOUDSAT')->first()->id,
            ],
        ]);

        DB::table('planes')->insert([
            [
                'nombre' => 'GOLD - CLOUDSAT',
                'uuid' => '89647481362183',
                'costo' => 500,

                'precio' => 1000,
                'proveedor_id' => Proveedor::where('empresa_id', '=', Empresa::where('razon', '=', 'CLOUDSAT')->first()->id)->first()->id,
            ],
        ]);
        DB::table('planes')->insert([
            [
                'nombre' => 'PLATINUM - CLOUDSAT',
                'uuid' => '89647481362183',
                'costo' => 1000,

                'precio' => 2000,
                'proveedor_id' => Proveedor::where('empresa_id', '=', Empresa::where('razon', '=', 'CLOUDSAT')->first()->id)->first()->id,
            ],
        ]);
        DB::table('planes')->insert([
            [
                'nombre' => 'DIAMOND - CLOUDSAT',
                'uuid' => '89647481362183',
                'costo' => 2000,
                'precio' => 3000,
                'proveedor_id' => Proveedor::where('empresa_id', '=', Empresa::where('razon', '=', 'CLOUDSAT')->first()->id)->first()->id,
            ],
        ]);
    }
}
