<?php

namespace Database\Seeders;

use App\Models\Mikrotik;
use App\Models\ProtocoloMikrotik;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

final class MikrotikProtocoloSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $mikrotiks = Mikrotik::all();
        $protocolos = ProtocoloMikrotik::all();

        foreach ($mikrotiks as $mikrotik) {
            foreach ($protocolos as $protocolo) {
                $mikrotik->protocolo()->attach($protocolo->id, ['puerto' => $protocolo->puerto, 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()]);
            }
        }
    }
}
