<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('facturas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('cobro_id')->unique();
            $table->integer('numero_factura')->unique();
            $table->date('fecha_emision');
            $table->string('cliente_nombre');
            $table->string('equipo')->nullable();
            $table->string('plan_nombre')->nullable();
            $table->text('concepto')->nullable();
            $table->decimal('monto_total', 10, 2);
            $table->date('fecha_cobro');
            $table->timestamps();

            $table->foreign('cobro_id')->references('id')->on('cobros')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('facturas');
    }
};
