<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        // id de la remota, fecha de la recarga, monto de la recarga, id del usuario que recargo, metodo de pago id de la recarga
        Schema::create('historial_de_recargas', function (Blueprint $table) {

            $table->id();
            $table->foreignId('remota_id')->constrained('remotas');
            $table->date('fecha_de_recarga');
            $table->decimal('monto_de_recarga', 10, 2);
            $table->foreignId('payment_method_id')->constrained('payment_methods');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('historial_de_recargas');
    }
};
