<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payment_methods', function (Blueprint $table) {
            // Agregar columna 'tipo_metodo_pago' como ENUM
            $table->enum('tipo_metodo_pago', ['cliente', 'empresa'])->default('cliente')->after('is_active'); // o 'empresa'
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payment_methods', function (Blueprint $table) {
            // Eliminar columna 'tipo_metodo_pago'
            $table->dropColumn('tipo_metodo_pago');
        });
    }
};
