<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            DB::beginTransaction();

            // Obtener o crear el rol ADMIN
            $adminRole = Role::findByName('ADMIN');
            if (!$adminRole) {
                $adminRole = Role::create([
                    'name' => trim(strtoupper('ADMIN')),
                    'guard_name' => 'web'
                ]);
            }

            // Lista de permisos
            $permisos = [
                'remotas_satelital.index',
                'remotas_satelital.create',
                'remotas_satelital.edit',
                'remotas_satelital.show_detail',
                'remotas_satelital.delete',
            ];

            foreach ($permisos as $permiso) {
                $permission = Permission::firstOrCreate(
                    ['name' => str_replace(' ', '_', trim(strtolower($permiso))), 'guard_name' => 'web']
                );

                // Asignar el permiso al rol ADMIN
                if (!$adminRole->hasPermissionTo($permission, 'web')) {
                    $adminRole->givePermissionTo($permission);
                }
            }



            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack(); // Asegúrate de hacer rollback en caso de error
            throw $th; // Lanzar la excepción después de hacer rollback
        }
    }

    public function down(): void
    {
        try {
            DB::beginTransaction();

            // Obtener el rol ADMIN
            $adminRole = Role::findByName('ADMIN');

            // Lista de permisos a eliminar
            $permisos = [
                'remotas_satelital.index',
                'remotas_satelital.create',
                'remotas_satelital.edit',
                'remotas_satelital.show_detail',
                'remotas_satelital.delete',
            ];

            foreach ($permisos as $permiso) {
                $permission = Permission::where('name', str_replace(' ', '_', trim(strtolower($permiso))))->first();

                // Si el permiso existe, revocar del rol y eliminarlo
                if ($permission) {
                    if ($adminRole && $adminRole->hasPermissionTo($permission, 'web')) {
                        $adminRole->revokePermissionTo($permission);
                    }
                    $permission->delete();
                }
            }

            // Eliminar el rol ADMIN si no tiene permisos
            if ($adminRole && $adminRole->permissions()->count() === 0) {
                $adminRole->delete();
            }

            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack(); // Asegúrate de hacer rollback en caso de error
            throw $th; // Lanzar la excepción después de hacer rollback
        }
    }
};
