<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            DB::beginTransaction();

            // Obtener o crear el rol ADMIN
            $adminRole = Role::findByName('ADMIN');
            if (!$adminRole) {
                $adminRole = Role::create([
                    'name' => trim(strtoupper('ADMIN')),
                    'guard_name' => 'web'
                ]);
            }

            // Lista de permisos
            $permisos = [
                'cobranzas.cobros_particulares.pagar',
                'cobranzas.cobros_particulares.exonerar',
                'cobranzas.cobros_particulares.eliminar_cobro',
                'cobranzas.cobros_particulares.agregar'
            ];

            foreach ($permisos as $permiso) {
                $permission = Permission::firstOrCreate(
                    ['name' => str_replace(' ', '_', trim(strtolower($permiso))), 'guard_name' => 'web']
                );

                // Asignar el permiso al rol ADMIN
                if (!$adminRole->hasPermissionTo($permission, 'web')) {
                    $adminRole->givePermissionTo($permission);
                }
            }



            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack(); // Asegúrate de hacer rollback en caso de error
            throw $th; // Lanzar la excepción después de hacer rollback
        }
    }

    /**
     * Reverse the migrations.
     */

    public function down(): void
    {
        try {
            DB::beginTransaction();

            // Obtener el rol ADMIN
            $adminRole = Role::findByName('ADMIN');

            // Lista de permisos
            $permisos = [
                'cobranzas.cobros_particulares.pagar',
                'cobranzas.cobros_particulares.exonerar',
                'cobranzas.cobros_particulares.eliminar_cobro',
                'cobranzas.cobros_particulares.agregar'
            ];

            foreach ($permisos as $permiso) {
                $permission = Permission::findByName(str_replace(' ', '_', trim(strtolower($permiso))), 'web');

                // Revocar el permiso del rol ADMIN si existe
                if ($adminRole && $permission) {
                    $adminRole->revokePermissionTo($permission);
                }

                // Eliminar el permiso si no está asignado a ningún rol
                if ($permission && $permission->roles->isEmpty()) {
                    $permission->delete();
                }
            }

            // Eliminar el rol ADMIN si no tiene permisos
            if ($adminRole && $adminRole->permissions->isEmpty()) {
                $adminRole->delete();
            }

            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack(); // Asegúrate de hacer rollback en caso de error
            throw $th; // Lanzar la excepción después de hacer rollback
        }
    }
};
