<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Hash;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //================================= Roles
        $adminRole = DB::table('roles')->where('name', 'ADMIN')->first();

        if (!$adminRole) {
            $adminRoleId = DB::table('roles')->insertGetId(['name' => 'ADMIN', 'guard_name' => 'web']);
        } else {
            $adminRoleId = $adminRole->id;
        }

        //================================= Permisos
        $modules = ['personas', 'clientes', 'mikrotik', 'remota_satelital', 'cobranzas', 'administrador'];

        foreach ($modules as $modulo) {
            $module_permission_name = $modulo . "_module";
            $exists = DB::table('permissions')->where('name', $module_permission_name)->exists();

            if (!$exists) {
                $permission_id = DB::table('permissions')->insertGetId(['name' => $module_permission_name, 'guard_name' => 'web']);

                $hasPermission = DB::table('role_has_permissions')
                    ->where('role_id', $adminRoleId)
                    ->where('permission_id', $permission_id)
                    ->exists();

                if (!$hasPermission) {
                    DB::table('role_has_permissions')->insert([
                        'role_id' => $adminRoleId,
                        'permission_id' => $permission_id
                    ]);
                }
            }
        }

        $userEmails = ['alfonzzoj@cloudsatllc.com', 'reynaldo.carima@gmail.com'];
        $foundUsers = [];

        foreach ($userEmails as $email) {
            $user = DB::table('users')->where('email', $email)->first();

            if ($user) {
                $foundUsers[] = $user; // Guardar el usuario encontrado
                $hasRole = DB::table('model_has_roles')
                    ->where('model_id', $user->id)
                    ->where('role_id', $adminRoleId)
                    ->exists();

                if (!$hasRole) {
                    DB::table('model_has_roles')->insert([
                        'role_id' => $adminRoleId,
                        'model_type' => 'App\Models\User',
                        'model_id' => $user->id
                    ]);
                }
            }
        }

        // Si no se encontraron usuarios, crear uno nuevo
        if (empty($foundUsers)) {
            $newUserId = DB::table('users')->insertGetId([
                'name' => 'Admin Test', // Cambia esto según sea necesario
                'email' => 'admintest@cloudsat.com', // Cambia esto según sea necesario
                'password' => Hash::make('password'), // Cambia esto según sea necesario
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('model_has_roles')->insert([
                'role_id' => $adminRoleId,
                'model_type' => 'App\Models\User',
                'model_id' => $newUserId
            ]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // DB::table('roles')->where('name', 'ADMIN')->delete();
        // DB::table('permissions')->where('name', 'ADMIN')->delete();
    }
};
