<?php

use App\Models\PaymentMethod;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('payment_methods')) {
            # code...
            Schema::create('payment_methods', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->text('description')->nullable();
                $table->string('type')->nullable();
                $table->boolean('is_active')->default(true);
                $table->timestamps();
            });
            // Define seed data
            $paymentMethods = [
                [
                    'name' => 'Efectivo',
                    'description' => 'Dolares en efectivo',
                    'type' => 'cash',
                ],
                [
                    'name' => 'Zelle',
                    'description' => 'Transferencia electronica en dolares',
                    'type' => 'bank_transfer',
                ],
                [
                    'name' => 'Bancolombia',
                    'description' => 'Transferencia electronica en pesos',
                    'type' => 'bank_transfer',
                ],
                [
                    'name' => 'Transferencia nacional',
                    'description' => 'Transferencia electronica en bolivares bancos venezolanos',
                    'type' => 'bank_transfer',
                ],
                [
                    'name' => 'Banesco panama',
                    'description' => 'Transferencia electronica en dolares',
                    'type' => 'bank_transfer',
                ],
                [
                    'name' => 'Pago movil',
                    'description' => 'Transferencia electronica en bolivares',
                    'type' => 'transfer',
                ],
                [
                    'name' => 'USDT',
                    'description' => 'Transferencia electronica en dolares',
                    'type' => 'wallet',
                ],
            ];

            // Insert data into the table
            foreach ($paymentMethods as $paymentMethod) {
                PaymentMethod::create($paymentMethod);
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_methods');
    }
};
