<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('remotas', function (Blueprint $table) {
            // Agregar foregin key en el campo de la tabla tipo_router que apunte al id de la tabla modelos_mikrotiks, si se bor
            // borrar columna tipo router
            $table->dropColumn('tipo_router');
            $table->unsignedBigInteger('tipo_router_id')->nullable()->after('equipo');
            $table->foreign('tipo_router_id')->references('id')->on('modelos_mikrotiks')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('remotas', function (Blueprint $table) {
            $table->dropForeign(['tipo_router_id']);
            $table->dropColumn('tipo_router_id');

            $table->string('tipo_router')->after('equipo');
        });
    }
};
