<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('remotas', function (Blueprint $table) {

            // tipo_router
            $table->string('tipo_router')->nullable()->after('equipo');
            // puerto
            $table->string('puerto')->nullable()->after('tipo_router');
            // ubicacion
            $table->string('ubicacion')->nullable()->after('puerto');
            // zona
            $table->string('zona')->nullable()->after('ubicacion');
            // encargado
            $table->string('encargado')->nullable()->after('zona');
            // correo_cuenta
            $table->string('correo_cuenta')->nullable()->after('dia_activacion');
            // password_correo_cuenta
            $table->string('password_correo_cuenta')->nullable()->after('correo_cuenta');
            // socio ahora puede ser nullo
            $table->integer('meses_contrato')->unsigned()->nullable()->after('puerto')->default(0);
            $table->enum('status', ['activo', 'inactivo', 'pausada'])->default('activo')->after('password_correo_cuenta');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('remotas', function (Blueprint $table) {
            $table->dropColumn('tipo_router');
            $table->dropColumn('puerto');
            $table->dropColumn('ubicacion');
            $table->dropColumn('zona');
            $table->dropColumn('encargado');
            $table->dropColumn('correo_cuenta');
            $table->dropColumn('password_correo_cuenta');
            $table->dropColumn('meses_contrato');
            $table->dropColumn('status');
        });
    }
};
