<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cobros', function (Blueprint $table) {
            $table->id();
            $table->foreignId('remota_id')->references('id')->on('remotas')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('plan_id')->references('id')->on('planes')->onUpdate('cascade')->onDelete('cascade');
            $table->date('fecha_cobro')->nullable();
            $table->decimal('monto', 10, 2)->default(0);
            $table->decimal('utilidades', 10, 2)->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cobros');
    }
};
