<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mikrotiks', function (Blueprint $table) {
            $table->id();
            $table->string('nombre', 50);
            $table->ipAddress('ip', 32);
            $table->string('serial', 50);
            $table->string('identify', 50);
            $table->foreignId('modelo_mikrotik_id')->references('id')->on('modelos_mikrotiks')->onUpdate('cascade')->onDelete('restrict');
            $table->string('vpn_user', 30);
            $table->string('vpn_password', 30);
            $table->string('vpn_server', 50);
            $table->string('ethr_corte1', 50)->nullable();
            $table->string('ethr_corte2', 50)->nullable();
            $table->string('usuario');
            $table->string('clave', 50);
            $table->uuid();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // eliminar mikrotik_protocolo_mikrotik_mikrotik_id_foreign
        Schema::table('mikrotik_protocolo_mikrotik', function (Blueprint $table) {
            $table->dropForeign('mikrotik_protocolo_mikrotik_mikrotik_id_foreign');
        });
        Schema::dropIfExists('mikrotiks');
    }
};
