<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('protocolos_mikrotiks', function (Blueprint $table) {
            $table->id();
            $table->string('protocolo')->unique();
            $table->unsignedMediumInteger('puerto')->unique();
            $table->uuid();
            $table->softDeletes();
            $table->timestamps();
        });

        DB::table('protocolos_mikrotiks')->insert([
            ['protocolo' => 'telnet', 'puerto' => 23, 'uuid' => str()->uuid()->toString()],
            ['protocolo' => 'ftp', 'puerto' => 21, 'uuid' => str()->uuid()->toString()],
            ['protocolo' => 'www', 'puerto' => 80, 'uuid' => str()->uuid()->toString()],
            ['protocolo' => 'ssh', 'puerto' => 22, 'uuid' => str()->uuid()->toString()],
            ['protocolo' => 'www-ssl', 'puerto' => 443, 'uuid' => str()->uuid()->toString()],
            ['protocolo' => 'api', 'puerto' => 8728, 'uuid' => str()->uuid()->toString()],
            ['protocolo' => 'winbox', 'puerto' => 8291, 'uuid' => str()->uuid()->toString()],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('protocolos_mikrotiks');
    }
};
