<?php

use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('modelos_mikrotiks', function (Blueprint $table) {
            $table->id();
            $table->string('nombre', 50)->unique();
            $table->uuid();
            $table->timestamps();
            $table->softDeletes();
        });

        DB::table('modelos_mikrotiks')->insert([
            ['nombre' => 'CRS310-8G+2S+IN', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'RB260GS', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'RB260GSP', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS106-1C-5S', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CSS610-8G-2S+IN', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'netPower Lite 7R', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS305-1G-4S+IN', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS112-8G-4S-IN', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CSS326-24G-2S+RM', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'netPower 15FR', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS326-24G-2S+IN', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS310-1G-5S-4S+IN', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS326-24G-2S+RM', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS112-8P-4S-IN', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CSS610-8P-2S+IN', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'FiberBox Plus', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'netFiber 9', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS309-1G-8S+IN', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'netPower 16P', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS328-4C-20S-4S+RM', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS328-24P-4S+RM', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS317-1G-16S+RM', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS326-24S+2Q+RM', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS354-48G-4S+2Q+RM', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS312-4C+8XG-RM', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS504-4XQ-IN', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS504-4XQ-OUT', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS354-48P-4S+2Q+RM', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS510-8XS-2XQ-IN', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['nombre' => 'CRS518-16XS-2XQ-RM', 'uuid' => str()->uuid()->toString(), 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mikrotiks_models');
    }
};
