<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('empresas', function (Blueprint $table) {
            $table->id();
            $table->string('rif')->unique();
            $table->string('razon')->unique();
            $table->string('direccion')->nullable();
            $table->string('telefono', 20);
            $table->string('telefono_secundario', 20)->nullable();
            $table->string('whatsapp', 20)->nullable();
            $table->string('telegram', 20)->nullable();
            $table->string('correo', 40)->nullable();
            $table->uuid();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('empresas');
    }
};
