<?php

use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->string('password');
            $table->rememberToken();
            $table->string('profile_photo_path', 2048)->nullable();
            $table->uuid();
            $table->softDeletes();
            $table->timestamps();
        });

        DB::table('users')->insert([
            [
                'name' => 'Administrador',
                'email' => 'alfonzzoj@cloudsatllc.com',
                'password' => Hash::make('5tY7&6ohE*oh327w%'),
                'uuid' => str()->uuid()->toString(),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ]);
        DB::table('users')->insert([
            [
                'name' => 'Reynaldo Carima',
                'email' => 'reynaldo.carima@gmail.com',
                'password' => Hash::make('Amaya1414..'),
                'uuid' => str()->uuid()->toString(),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
