<?php

namespace Database\Factories;

use App\Models\Cliente;
use App\Models\Remota;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Cobranza>
 */
class RemotasConCobrosFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'cliente_id' => Cliente::all()->count() > 0 ? Cliente::all()->random()->id : Cliente::factory(),
            'concepto' => 'Pago de mensualisad',
            'remota_id' => Remota::all()->count() > 0   ? Remota::all()->random()->id   : Remota::factory(),
            'monto' => $this->faker->randomFloat(2, 100, 1000),
            'fecha' => $this->faker->dateTimeBetween('-1 days', '+1 days'),
            'status' => 'pendiente',
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }
}
