<?php

namespace Database\Factories;

use App\Models\Cliente;
use App\Models\ModeloMikrotik;
use App\Models\Plan;
use App\Models\Proveedor;
use App\Models\Socio;
use App\Models\Vendedor;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Remota>
 */
final class RemotaFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        // Tipo router id se saca de un random de la tabla modelos_mikrotiks

        return [
            // Antena info
            'equipo' => $this->faker->name(),
            'tipo_router_id' => ModeloMikrotik::all()->random()->id ?? null,
            'puerto' => $this->faker->numerify('##'),
            'ip_gestion' => $this->faker->ipv4(),
            'meses_contrato' => $this->faker->randomDigit(),
            'ubicacion' => $this->faker->address(),
            'zona' => $this->faker->country(),
            'detalle' => $this->faker->words(asText: true),

            // Seriales
            'serial' => $this->faker->numerify('######'),
            'kit_serial' => $this->faker->numerify('######'),
            'antena_serial' => $this->faker->numerify('######'),
            // Fechas
            // 'dia_corte' => $this->faker->dateTimeBetween('-15 days', '+10 days'),
            'dia_corte' => $this->faker->dateTimeBetween(now()->startOfMonth(), now()->endOfMonth()),
            'dia_activacion' => $this->faker->dateTimeBetween('-1 days', '+1 days'),
            // Cuenta
            'correo_cuenta' => $this->faker->unique()->email(),
            'password_correo_cuenta' => $this->faker->password(),
            'status' => $this->faker->randomElement(['activo',   'inactivo', 'pausada', 'activo', 'pausada_por_pago', 'cancelada', 'activo',]),
            'fecha_cuenta' => $this->faker->dateTimeBetween('-1 days', '+1 days'),
            // Asociados
            'cliente_id' =>   Cliente::all()->count() > 0   ? Cliente::all()->random()->id   : Cliente::factory(),
            'plan_id' =>      Plan::all()->count() > 0      ? Plan::all()->random()->id      :  Plan::factory(),
            'socio_id' =>     Socio::all()->count() > 0     ? Socio::all()->random()->id     :  Socio::factory(),
            'vendedor_id' =>  Vendedor::all()->count() > 0  ? Vendedor::all()->random()->id  : Vendedor::factory(),
            'proveedor_id' => Proveedor::all()->count() > 0 ? Proveedor::all()->random()->id : Proveedor::factory(),
            'uuid' => str()->uuid(),
        ];
    }
}
