<?php

namespace Database\Factories;

use App\Models\Proveedor;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Plan>
 */
final class PlanFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        if (Proveedor::all()->count() === 0) {
            Proveedor::factory()->create();
        }
        $nombres_de_planes = [
            'STANDARD',
            'PREMIUM',
            'TURBO',
            'BASICO',
            'PLUS',
            'GOLD',
            'SILVER',
            'BRONZE',
        ];
        return [
            'nombre' => $this->faker->randomElement($nombres_de_planes),
            'costo' => $this->faker->randomFloat(nbMaxDecimals: 2, min: 40, max: 200),
            'precio' => $this->faker->randomFloat(nbMaxDecimals: 2, min: 10, max: 1000),
            'uuid' => $this->faker->uuid(),
            // 'proveedor_id' =>  Proveedor::factory(),
            'proveedor_id' => Proveedor::all()->random()->id,


        ];
    }
}
