<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Persona>
 */
final class PersonaFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'nombres' => $this->faker->name(),
            'cedula' => $this->faker->numerify('V########'),
            'direccion' => $this->faker->address(),
            'telefono' => $this->faker->phoneNumber(),
            'telefono_secundario' => $this->faker->phoneNumber(),
            'whatsapp' => $this->faker->phoneNumber(),
            'telegram' => $this->faker->phoneNumber(),
            'correo' => $this->faker->safeEmail(),
            'uuid' => $this->faker->uuid(),
        ];
    }
}
