<?php

namespace Database\Factories;

use App\Models\Empresa;
use App\Models\Persona;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Cliente>
 */
final class ClienteFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        $clientable = $this->clientable();

        return [
            'clientable_id' => $clientable::factory(),
            'clientable_type' => $clientable,
            'uuid' => $this->faker->uuid(),
        ];
    }

    public function clientable()
    {
        return $this->faker->randomElement([Empresa::class, Persona::class]);
    }
}
