<?php

use App\Models\Configuracion;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;

if (!function_exists('get_logo_sistema')) {
    function get_logo_sistema(): string
    {
        $logo = Cache::remember('logo', 60, function () {
            return Configuracion::where('clave', 'like', 'logo')->value('valor');
        });

        return $logo ? Storage::url($logo) : asset('light-bootstrap/img/logo.png');
    }
}

if (!function_exists('is_current_route')) {
    function is_current_route(array $routes): bool
    {
        foreach ($routes as $route) {
            if (Route::currentRouteName() == $route) {
                return true;
            }
        }

        return false;
    }
}

if (!function_exists('get_cedula')) {

    function get_cedula(string $numero, string $nacionalidad = 'v')
    {
        if ($numero == '') {
            return null;
        }
        return strtoupper($nacionalidad) . $numero;
    }
}
// if (!function_exists('get_cedula')) {

//     function get_cedula(string $numero, string $nacionalidad = 'v'): string
//     {
//         if ($numero == '') {
//             return null;
//         }
//         return strtoupper($nacionalidad) . str_pad($numero, 8, '0', STR_PAD_LEFT);
//     }
// }
