<?php

namespace App\Models;

use App\Traits\HasEmpresa;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

final class Proveedor extends Model
{
    use HasEmpresa;
    use HasFactory;

    protected $table = 'proveedores';

    protected $with = ['empresa'];

    protected $fillable = ['empresa_id'];

    public function empresa(): BelongsTo
    {
        return $this->belongsTo(Empresa::class);
    }
    public function remotas()
    {
        return $this->hasMany(Remota::class);
    }
}
