<?php

namespace App\Models;

use App\Traits\GenerateUuid;
use App\Traits\RouteUuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Laravel\Scout\Searchable;

final class ProtocoloMikrotik extends Model
{
    use GenerateUuid;
    use HasFactory;
    use RouteUuid;
    use Searchable;
    use SoftDeletes;

    protected $table = 'protocolos_mikrotiks';

    protected $fillable = ['protocolo', 'puerto'];

    public function mikrotiks(): BelongsToMany
    {
        return $this->belongsToMany(Mikrotik::class);
    }

    public function toSearchableArray()
    {
        return [
            'protocolo' => $this->protocolo,
        ];
    }
}
