<?php

namespace App\Models;

use App\Traits\GenerateUuid;
use App\Traits\RouteUuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Laravel\Scout\Searchable;

final class Plan extends Model
{
    use GenerateUuid;
    use HasFactory;
    use RouteUuid;
    use Searchable;

    protected $table = 'planes';

    protected $fillable = ['nombre', 'costo', 'precio', 'proveedor_id'];

    public function toSearchableArray()
    {
        return [
            'nombre' => $this->nombre,
        ];
    }
    public function proveedor(): BelongsTo
    {
        return $this->belongsTo(Proveedor::class);
    }
    // remotas a las que esta asignado ese plan
    public function remotas()
    {
        return $this->hasMany(Remota::class, 'plan_id');
    }
}
